package com.yonyou.uap.tenant.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import uap.web.core.ContextHolder;

public class ResGroupService {
	
	public JdbcTemplate getJdbcTemplateDao(){
		return (JdbcTemplate) ContextHolder.getContext().getBean("jdbcTemplateDao");
	}

	public boolean isGroupCode(String systemCode) {
		String selectSql = "select count(id) as cnt from pub_auth_group_res r where r.group_code=? " ;
		Object args[] = new Object[]{systemCode};  
		Long groupCount = getJdbcTemplateDao().queryForObject(selectSql, args, Long.class);
		if(groupCount > 0) {
			return true;
		}else{
			return false;
		}
	}

	public String[] getResCodes(String systemCode) {
		String[] resArr = new String[0];
		String selectSql = "select * from pub_auth_group_res where group_code=? ";
		
		List<String> resCodeList = getJdbcTemplateDao().query(selectSql, new RowMapper<String>() {
			@Override
			public String mapRow(ResultSet rs, int rowNum) throws SQLException {
				return rs.getString("res_code");
			}
		}, systemCode);
		
		if(resCodeList != null && resCodeList.size() > 0) {
			resArr = new String[resCodeList.size()];
			for(int i=0;i<resCodeList.size();i++) {
				resArr[i] = resCodeList.get(i);
			}
			return resArr;
		}
		return resArr;
	}

}
