package com.yonyou.uap.tenant.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import com.yonyou.uap.tenant.entity.ResTenant;

import uap.web.core.ContextHolder;

public class ResTenantService {
	
	public JdbcTemplate getJdbcTemplateDao(){
		return (JdbcTemplate) ContextHolder.getContext().getBean("jdbcTemplateDao");
	}
	
	public int isNeedTenant(String systemCode) {
		String selectSql = "select * from pub_res_tenant where res_code = ? ";
		
		List<ResTenant> resTenantList =  getJdbcTemplateDao().query(selectSql, new RowMapper<ResTenant>() {
			@Override
			public ResTenant mapRow(ResultSet rs, int rowNum) throws SQLException {
				ResTenant vo = new ResTenant(rs.getString("id"), rs.getString("res_code"), rs.getInt("need_tenant"));
				return vo;
			}
		}, systemCode);
		
		ResTenant resTenant = null;
		if(resTenantList != null && resTenantList.size() > 0) {
			resTenant = resTenantList.get(0);
		}
		
		if ((resTenant == null) || (resTenant.getNeedTenant() > 1) || (resTenant.getNeedTenant() < 0)) {
			return 2;
		}
		return resTenant.getNeedTenant();
	}

}
