package com.yonyou.uap.tenant.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import com.yonyou.uap.tenant.entity.TenantRes;

import uap.web.core.ContextHolder;

public class TenantResService {

	public JdbcTemplate getJdbcTemplateDao(){
		return (JdbcTemplate) ContextHolder.getContext().getBean("jdbcTemplateDao");
	}

	
	public TenantRes findByTenantIdAndSystemCode2(String tenantId, String systemCode) {
		String selectSql = "select * from pub_tenant_res where tenant_id =? and res_code =?";
		List<TenantRes> tenantResList = getJdbcTemplateDao().query(selectSql, new RowMapper<TenantRes>() {
			@Override
			public TenantRes mapRow(ResultSet rs, int rowNum) throws SQLException {
				TenantRes vo = new TenantRes(rs.getString("id"), rs.getString("res_code"), rs.getString("res_id"),
				rs.getInt("states"), rs.getString("tenant_code"), rs.getString("tenant_id"), 
				rs.getString("begin_date"), rs.getString("end_date"), rs.getString("buy_time"));
				return vo;
			}
		}, tenantId,systemCode);
		
		if ((tenantResList != null) && (tenantResList.size() > 0)) {
			return tenantResList.get(0);
		}
		return null;
	}

}
