package com.yonyou.uap.tenant.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import com.yonyou.uap.tenant.entity.Tenant;

import uap.web.core.ContextHolder;

public class TenantService {
	
	public JdbcTemplate getJdbcTemplateDao(){
		return (JdbcTemplate) ContextHolder.getContext().getBean("jdbcTemplateDao");
	}

	public Tenant getPubTenantById(String tenantId) {
		List<Tenant> tenantList = null;
		String selectSql = " select * from pub_tenant where tenant_id = ?  ";
		
		tenantList = getJdbcTemplateDao().query(selectSql, new RowMapper<Tenant>() {
			@Override
			public Tenant mapRow(ResultSet rs, int rowNum) throws SQLException {
				Tenant vo = new Tenant(rs.getString("tenant_id"), rs.getString("tenant_address"), rs.getString("tenant_area"), rs.getString("tenant_code"), rs.getString("tenant_email"), rs.getString("tenant_fullname"), 
				rs.getString("tenant_industry"), rs.getString("tenant_name"), rs.getString("tenant_nature"), rs.getString("tenant_offical_web"), rs.getInt("tenant_states"), rs.getString("tenant_tel"), rs.getString("tenant_pwdpolicy"));
				return vo;
			}
		}, tenantId);
		
		if(tenantList != null && tenantList.size() > 0) {
			return tenantList.get(0);
		}
		return null;
	}
	
	

}
