package com.yonyou.uap.tenant.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import com.yonyou.uap.tenant.entity.TenantUser;

import uap.web.core.ContextHolder;

public class TenantUserService {

	public JdbcTemplate getJdbcTemplateDao(){
		return (JdbcTemplate) ContextHolder.getContext().getBean("jdbcTemplateDao");
	}
	
	public List<TenantUser> findByLoginName(String userName) {
		List<TenantUser> tenantUserList = new ArrayList<TenantUser>();
		
		String selectSql = "select * from pub_tenant_user where user_code = ? and dr=0 ";
		
		tenantUserList = getJdbcTemplateDao().query(selectSql, new RowMapper<TenantUser>() {
			@Override
			public TenantUser mapRow(ResultSet rs, int rowNum) throws SQLException {
				TenantUser vo = new TenantUser(rs.getString("user_id"), rs.getString("company_id"), rs.getString("department_id"), rs.getString("register_date"), rs.getString("salt"), rs.getString("tenant_id"), rs.getInt("type_id"), rs.getString("user_avator"), 
				rs.getString("user_code"), rs.getString("user_email"), rs.getString("user_mobile"), rs.getString("user_code"), rs.getString("user_password"), rs.getInt("user_states"), 
				0L, rs.getString("system_id"), rs.getString("source_id"), rs.getString("pwdstarttime"), rs.getString("secretkey"), rs.getString("outdate"), rs.getInt("mailvalidatect"), "", true, 0L);
				return vo;
			}
		}, userName);
		
		if(tenantUserList != null && tenantUserList.size() > 0) {
			return tenantUserList;
		}else{
			selectSql = "select * from pub_tenant_user where user_mobile = ? and dr=0 ";
			tenantUserList = getJdbcTemplateDao().query(selectSql, new RowMapper<TenantUser>() {
				@Override
				public TenantUser mapRow(ResultSet rs, int rowNum) throws SQLException {
					TenantUser vo = new TenantUser(rs.getString("user_id"), rs.getString("company_id"), rs.getString("department_id"), rs.getString("register_date"), rs.getString("salt"), rs.getString("tenant_id"), rs.getInt("type_id"), rs.getString("user_avator"), 
					rs.getString("user_code"), rs.getString("user_email"), rs.getString("user_mobile"), rs.getString("user_code"), rs.getString("user_password"), rs.getInt("user_states"), 
					0L, rs.getString("system_id"), rs.getString("source_id"), rs.getString("pwdstarttime"), rs.getString("secretkey"), rs.getString("outdate"), rs.getInt("mailvalidatect"), "", true, 0L);
					return vo;
				}
			}, userName);
			
			if(tenantUserList != null && tenantUserList.size() > 0) {
				return tenantUserList;
			}else{
				selectSql = "select * from pub_tenant_user where user_email = ? and dr=0 ";
				tenantUserList = getJdbcTemplateDao().query(selectSql, new RowMapper<TenantUser>() {
					@Override
					public TenantUser mapRow(ResultSet rs, int rowNum) throws SQLException {
						TenantUser vo = new TenantUser(rs.getString("user_id"), rs.getString("company_id"), rs.getString("department_id"), rs.getString("register_date"), rs.getString("salt"), rs.getString("tenant_id"), rs.getInt("type_id"), rs.getString("user_avator"), 
						rs.getString("user_code"), rs.getString("user_email"), rs.getString("user_mobile"), rs.getString("user_code"), rs.getString("user_password"), rs.getInt("user_states"), 
						0L, rs.getString("system_id"), rs.getString("source_id"), rs.getString("pwdstarttime"), rs.getString("secretkey"), rs.getString("outdate"), rs.getInt("mailvalidatect"), "", true, 0L);
						return vo;
					}
				}, userName);
				
				return tenantUserList;
			}
		}
	}

	
	
}
