package com.yonyou.uap.tenant.service.impl;

import org.springframework.jdbc.core.JdbcTemplate;

import uap.web.core.ContextHolder;

public class UserPermissionService {

	public JdbcTemplate getJdbcTemplateDao(){
		return (JdbcTemplate) ContextHolder.getContext().getBean("jdbcTemplateDao");
	}

	public boolean havePermission(String userId, String systemCode) {
		String selectSql = "select count(1) from pub_tenant_user_permission where user_id = ? and res_code = ? ";
		Object args[] = new Object[]{userId,systemCode};  
		Long permissionCount = getJdbcTemplateDao().queryForObject(selectSql, args, Long.class);
		if(permissionCount > 0) {
			return true;
		}else{
			return false;
		}
	}

}
