package com.yonyou.uap.tenant.servlet;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;

import net.sf.json.JSONObject;
import uap.web.cache.CacheManager;
import uap.web.core.ContextHolder;

public class ValidateCodeServlet extends HttpServlet {
	
	private static final long serialVersionUID = 5530784399527847517L;

	protected void doGet(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
		validateCode(req, response);
	}

	protected void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		super.doPost(request, response);
		validateCode(request, response);
	}

	public void init() throws ServletException {
		super.init();
	}

	private void validateCode(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		Map<String,Object> results = new LinkedHashMap<String,Object>();
		CacheManager cacheManager = (CacheManager) ContextHolder.getContext().getBean("cacheManager");

		String key = request.getParameter("key");
		String code = request.getParameter("code");
		String saveVCode = (String) cacheManager.get(key + code.toLowerCase());
		if (StringUtils.isNotBlank(saveVCode)) {
			cacheManager.removeCache(key);
			results.put("msg", "success");
			results.put("status", Integer.valueOf(1));
		} else {
			results.put("msg", "failture");
			results.put("status", Integer.valueOf(0));
		}
		JSONObject json = JSONObject.fromObject(results);
		response.getWriter().write(json.toString());
	}
}