package com.yonyou.uap.tenant.userlistener;

import javax.validation.constraints.NotNull;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketListenerCleaner {
	private final Logger logger = LoggerFactory.getLogger(getClass());

	@NotNull
	private final CentralAuthenticationService centralAuthenticationService;

	public TicketListenerCleaner(CentralAuthenticationService centralAuthenticationService) {
		this.centralAuthenticationService = centralAuthenticationService;
	}

	public void clean(TicketGrantingTicket ticket) {
		this.logger.debug("Cleaning up expired ticket-granting ticket [{}]", ticket.getId());
		clean(ticket.getId());
	}

	public void clean(String ticketid) {
		this.centralAuthenticationService.destroyTicketGrantingTicket(ticketid);
	}
}