package com.yonyou.uap.tenant.userlistener;

import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.yonyou.iuap.event.common.BusinessEvent;
import com.yonyou.iuap.event.common.BusinessException;
import com.yonyou.iuap.event.common.IBussinessListener;

import uap.web.cache.CacheManager;
import uap.web.core.ContextHolder;

@SuppressWarnings("rawtypes")
public class UserChangeListener implements IBussinessListener {
	private final Logger logger = LoggerFactory.getLogger(getClass());

	public void doAction(BusinessEvent arg0) throws BusinessException {
		try {
			Map map = (Map) arg0.getUserObject();

			String userCode = (String) map.get("userCode");
			String name = "SSO_USERNAME_" + userCode;

			TicketListenerCleaner tCleaner = (TicketListenerCleaner) ContextHolder.getContext().getBean("ticketListenerCleaner");
			CacheManager cacheManager = (CacheManager) ContextHolder.getContext().getBean("cacheManager");

			if (cacheManager.exists(name).booleanValue()) {
				Map<String, Object> ticketMap = cacheManager.getAllSessionAttrCache(name);
				for (String ticketid : ticketMap.keySet()) {
					tCleaner.clean(ticketid);
					this.logger.debug("发送退出消息：" + ticketid);
					cacheManager.removeCacheAttribute(name, ticketid);
				}
			}
		} catch (Exception e) {
			this.logger.error(e.getMessage(), e);
		}
	}
}