package com.yonyou.uap.tenant.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.yonyou.iuap.security.esapi.IUAPEncoder;

public class CasPropertyUtil {
	private static final Logger logger = LoggerFactory.getLogger(CasPropertyUtil.class);

	private static Properties prop = null;

	public static String getPropertyByKey(String key) {
		String value = prop.getProperty(key);
		return StringUtils.isBlank(value) ? "" : value;
	}

	public static IUAPEncoder.DatabaseCodec getDataBaseCodec() {
		return IUAPEncoder.DatabaseCodec.MYSQL_ANSI;
	}

	static {
		prop = new Properties();

		InputStream in = null;
		try {
			in = Thread.currentThread().getContextClassLoader().getResourceAsStream("../cas.properties");
			prop.load(in);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		} finally {
			try {
				if (in != null)
					in.close();
			} catch (IOException e) {
				logger.error(e.getMessage(), e);
			}
		}
	}
}