package com.yonyou.uap.tenant.utils;

import java.util.LinkedHashMap;

public class JsonResponse extends LinkedHashMap<String, Object> {
	private static final long serialVersionUID = -3957696416833580484L;
	public static final int SUCCESS = 1;
	public static final int FAILED = 0;
	public static final int NOTFINISHED = 2;
	public static final String STATUS = "status";
	public static final String MESSAGE = "msg";

	public JsonResponse() {
	}

	public JsonResponse(int flag, String msg) {
		put("status", Integer.valueOf(flag));
		put("msg", msg);
	}

	public void failed(String msg) {
		put("status", Integer.valueOf(0));
		put("msg", msg);
	}

	public JsonResponse failedWithReturn(String msg) {
		put("status", Integer.valueOf(0));
		put("msg", msg);
		return this;
	}

	public void success() {
		put("status", Integer.valueOf(1));
	}

	public void success(String msg) {
		put("status", Integer.valueOf(1));
		put("msg", msg);
	}

	public void putValue(String key, Object value) {
		put(key, value);
	}

	public void successWithData(String key, Object value) {
		put("status", Integer.valueOf(1));
		put(key, value);
	}

	public void setStatus(int status) {
		put("status", Integer.valueOf(status));
	}

	public void setMessage(String msg) {
		put("msg", msg);
	}

	public String getMessage() {
		return (String) get("msg");
	}

	public boolean isfailed() {
		return (get("status") != null)
				&& (((Integer) get("status")).intValue() == 0);
	}
}