package com.yonyou.uap.tenant.utils;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springside.modules.security.utils.Digests;
import org.springside.modules.utils.Encodes;

import com.yonyou.uap.tenant.entity.PasswordLevel;
import com.yonyou.uap.tenant.entity.Tenant;
import com.yonyou.uap.tenant.entity.TenantRes;
import com.yonyou.uap.tenant.entity.TenantUser;
import com.yonyou.uap.tenant.service.impl.PasswordPolicyUtils;
import com.yonyou.uap.tenant.service.impl.ResGroupService;
import com.yonyou.uap.tenant.service.impl.ResTenantService;
import com.yonyou.uap.tenant.service.impl.TenantResService;
import com.yonyou.uap.tenant.service.impl.TenantService;
import com.yonyou.uap.tenant.service.impl.TenantUserService;
import com.yonyou.uap.tenant.service.impl.UserPermissionService;
import com.yonyou.uap.tenant.web.filter.PerformanceLoggerCollector;

import uap.web.cache.CacheManager;
import uap.web.core.ContextHolder;
import uap.web.utils.PropertyUtil;

@SuppressWarnings({ "unchecked" })
public class LoginRestUtil {
	private static final Logger logger = LoggerFactory.getLogger(UserValidate.class);
	
	public TenantUserService getTenantUserService(){
		return (TenantUserService) ContextHolder.getContext().getBean("userService");
	}
	
	public TenantService getTenantService(){
		return (TenantService) ContextHolder.getContext().getBean("tenantService");
	}
	
	public PasswordPolicyUtils getPasswordPolicyUtils(){
		return (PasswordPolicyUtils) ContextHolder.getContext().getBean("passwordUtil");
	}
	
	public JdbcTemplate getJdbcTemplate(){
		return (JdbcTemplate) ContextHolder.getContext().getBean("jdbcTemplateDao");
	}
	
	public CacheManager getCacheManager(){
		return (CacheManager) ContextHolder.getContext().getBean("cacheManager");
	}
	
	public ResGroupService getResGroupService(){
		return (ResGroupService) ContextHolder.getContext().getBean("resGroupService");
	}
	
	public ResTenantService getResTenantService(){
		return (ResTenantService) ContextHolder.getContext().getBean("resTenantService"); 
	}
	
	public TenantResService getTenantResService(){
		return (TenantResService) ContextHolder.getContext().getBean("tenantResService");
	}
	
	public UserPermissionService getUserPermissionService(){
		return (UserPermissionService) ContextHolder.getContext().getBean("userPermissionService");
	}

	@SuppressWarnings("unused")
	public JsonResponse userValidateService(String userName,String password,String systemId){
		PerformanceLoggerCollector.start("validateUser");
		JsonResponse json = new JsonResponse();
		if ((StringUtils.isBlank(userName)) || (StringUtils.isBlank(password))) {
			json.failed("用户名或密码为空");
			return json;
		}
		
		TenantUser user = null;
		PerformanceLoggerCollector.start("queryuser");
		List<TenantUser> userList = getTenantUserService().findByLoginName(userName);
		if(userList.size() == 0) {
			logger.error("数据有错误：根据用户名查找用户未匹配到用户，用户名：" + userName);
			json.failed("该用户名未匹配到用户");
			//this.userAuthSecurityLogUtils.onAuthFailed(userName, request,"数据有错误：根据用户名查找用户，用户名：" + userName);
			return json;
		}
		
		if(userList.size() > 1) {
			logger.error("数据有错误：根据用户名查找用户匹配到多个用户，用户名：" + userName);
			json.failed("该用户名匹配到多个用户");
			//this.userAuthSecurityLogUtils.onAuthFailed(userName, request,"数据有错误：根据用户名查找用户，用户名：" + userName);
			return json;
		}
		user = userList.get(0);

		String checkPwd = null;
		if (user != null) {
			if(!user.getUserPassword().equals(password)) {
			    checkPwd = PasswordUtils.encodePasswordByUserCode(password,user.getSalt(), user.getUserCode());
			}else{
				checkPwd = password;
			}
			
			if (user.getUserStates() == 0) {
				json.failed("用户已被停用");
				//this.userAuthSecurityLogUtils.onAuthFailed(user, request,json.getMessage());
				return json;
			}
			
			PerformanceLoggerCollector.stop("queryuser");
			PerformanceLoggerCollector.start("querytenant");
			Tenant tenant = getTenantService().getPubTenantById(user.getTenantId());

			if (tenant == null) {
				json.setStatus(4);
				json.setMessage("请先注册租户信息再登录");
				json.put("userTel", user.getUserMobile());
				//this.userAuthSecurityLogUtils.onAuthFailed(user, request,"请先注册租户信息再登录");
				return json;
			}

			String errorMsg = validateTenant(tenant, user, null);

			if (StringUtils.isNotBlank(errorMsg)) {
				return json.failedWithReturn(errorMsg);
			}

			PerformanceLoggerCollector.stop("querytenant");

			PerformanceLoggerCollector.start("queryPasswordPolicy");

			Map<String, Object> map = getPasswordPolicyUtils().getUserStatus(user.getUserId());
			Set<Integer> statusSet = (Set<Integer>) map.get("statusSet");
			Date exTime = (Date) map.get("extime");
			PasswordLevel pwdLevel = getPasswordPolicyUtils().getPasswordLevel(tenant.getPasswordPolicy());

			if (getPasswordPolicyUtils().isLockByAdmin(statusSet)) {
				json.failed("账户被管理员锁定，请联系管理员解锁");
				//this.userAuthSecurityLogUtils.onAuthFailed(user, request,json.getMessage());
				return json;
			}

			if (getPasswordPolicyUtils().isLockBySelf(statusSet)) {
				if (!getPasswordPolicyUtils().getUserIsLockStatus(exTime, pwdLevel,user.getUserId())) {
					json.failed("账户已被锁定，请稍后再试");
					//this.userAuthSecurityLogUtils.onAuthFailed(user, request,json.getMessage());
					return json;
				}
			}
			
			if (checkPwd.equals(user.getUserPassword())) {
				if (getPasswordPolicyUtils().isUserInitOrResetExStatus(statusSet) && mustModifyDefaultPwd(user.getTenantId())) {
					json.setStatus(2);
					json.setMessage("请修改密码");
					json.put("tenant", tenant.getTenantName());
					json.put("usertype", Integer.valueOf(user.getTypeId()));
					json.put("user", user);

					//this.userAuthSecurityLogUtils.onAuthFailed(user, request,json.getMessage());
					return json;
				}

				boolean flag = false;
				try {
					flag = getPasswordPolicyUtils().isUserPwdDisabled(user.getPwdstarttime(), pwdLevel);
				} catch (Exception e) {
					logger.error(e.getMessage(), e);
					json.failed("查询出错");
					//this.userAuthSecurityLogUtils.onAuthFailed(user, request,e.getMessage());
					return json;
				}
				if (flag) {
					json.setStatus(2);
					json.setMessage("密码已经超过有效期，请修改密码");
					json.put("tenant", tenant.getTenantName());
					json.put("usertype", Integer.valueOf(user.getTypeId()));
					json.put("user", user);

					//this.userAuthSecurityLogUtils.onAuthFailed(user, request,json.getMessage());
					return json;
				}

				String tip = null;
				try {
					tip = getPasswordPolicyUtils().getValidateTip(user.getPwdstarttime(), pwdLevel);
				} catch (Exception e) {
					logger.error(e.getMessage(), e);
					json.failed("查询出错");
					//this.userAuthSecurityLogUtils.onAuthFailed(user, request,e.getMessage());
					return json;
				}
				if (StringUtils.isNotBlank(tip)) {
					json.setStatus(3);
					json.setMessage(tip);
					json.put("url", "http://");
					json.put("tenant", tenant.getTenantName());
					json.put("usertype", Integer.valueOf(user.getTypeId()));
					json.put("user", user);
					//this.userAuthSecurityLogUtils.onAuthFailed(user, request,json.getMessage());
					return json;
				}

				String tenantDefaultPwdSQL = "select defaultpwd from pub_defaultpwd where tenant_id=?";
				String tenantDefaultPassword = getJdbcTemplate().queryForObject(tenantDefaultPwdSQL, String.class, user.getTenantId());

				if (tenantDefaultPassword != null && mustModifyDefaultPwd(user.getTenantId())) {
					String sha1DefaultPwd = Encodes.encodeHex(Digests.sha1(tenantDefaultPassword.getBytes()));

					String defaultPwd = PasswordUtils.encodePasswordByUserCode(sha1DefaultPwd,
							user.getSalt(), user.getUserCode());

					if (defaultPwd.equals(checkPwd)) {
						json.setStatus(2);
						json.setMessage("使用默认密码登陆，请修改密码");
						json.put("tenant", tenant.getTenantName());
						json.put("usertype", Integer.valueOf(user.getTypeId()));
						json.put("user", user);

						//this.userAuthSecurityLogUtils.onAuthFailed(user, request,json.getMessage());
						return json;
					}
				}


				PerformanceLoggerCollector.stop("queryPasswordPolicy");
				json.success("认证成功");
				//this.userAuthSecurityLogUtils.onAuthSuccess(user, request,json.getMessage());
				json.put("tenant", tenant.getTenantName());
				json.put("usertype", Integer.valueOf(user.getTypeId()));
				PerformanceLoggerCollector.start("fromObject");
				json.put("user", user);
				PerformanceLoggerCollector.stop("fromObject");
				PerformanceLoggerCollector.stop("validateUser");
			} else {
				if (getPasswordPolicyUtils().isLock(pwdLevel)) {
					String cacheKey = "errorPasswordCount_" + user.getUserId();
					Integer count = getCacheManager().get(cacheKey);
					if (count == null) {
						getCacheManager().putTimedCache(cacheKey,Integer.valueOf(1), 3600);
					} else {
						if (getPasswordPolicyUtils().isExceedErrorPasswordCount(pwdLevel, count + 1)) {
							getPasswordPolicyUtils().lockUser(user.getUserId());
							getCacheManager().removeCache(cacheKey);
							//this.userAuthSecurityLogUtils.onAuthFailed(user, request, "密码输错次数超过" + (count.intValue() - 1) + "次，账户被锁定");
							return json.failedWithReturn("密码输错次数超过" + pwdLevel.getErrorloginthreshold() + "次，账户被锁定");
						}
						Long ttl = getCacheManager().getTTL(cacheKey);
						Integer localInteger1 = count;
						Integer localInteger2 = count = count + 1;
						getCacheManager().putTimedCache(cacheKey, count,ttl.intValue());
					}
				}
				json.failed("用户名或密码错误");
				//this.userAuthSecurityLogUtils.onAuthFailed(user, request,json.getMessage());
				return json;
			}

			errorMsg = validateRes(tenant, user, systemId, null);

			if (StringUtils.isNotBlank(errorMsg)) {
				return json.failedWithReturn(errorMsg);
			}


		} else {
			json.failed("用户或密码不正确");
			//this.userAuthSecurityLogUtils.onAuthFailed(userName, request,json.getMessage());
		}
		return json;
	}
	
	public String validateTenant(Tenant tenant, TenantUser user,
			HttpServletRequest request) {
		if ((tenant != null) && (tenant.getTenantStates() == 0)) {
			//this.userAuthSecurityLogUtils.onAuthFailed(user, request, "租户未激活");
			return "租户未激活，请通过邮箱的链接激活租户";
		}
		return null;
	}
	
	public String validateRes(Tenant tenant, TenantUser user,
			String systemCode, HttpServletRequest request) {
		String errorMsg = new String();
		if (StringUtils.isNotBlank(systemCode)) {
			if ((systemCode.equals("tenantuser"))
					|| (systemCode.equals("tenant"))) {
				if (user.getTypeId() == 3) {
					errorMsg = "普通用户只能登录已购买的应用";
//					this.userAuthSecurityLogUtils.onAuthFailed(user, request,errorMsg);
				}
			} else if (getResGroupService().isGroupCode(systemCode)) {
				String[] resCodes = getResGroupService().getResCodes(systemCode);
				for (String resCode : resCodes) {
					errorMsg = validateSingleRes(tenant, user, resCode, request);
					if (StringUtils.isBlank(errorMsg))
						return null;
				}
			} else {
				errorMsg = validateSingleRes(tenant, user, systemCode, request);
			}
			if (StringUtils.isNotBlank(errorMsg))
				return errorMsg;
		} else {
			//this.userAuthSecurityLogUtils.onAuthFailed(user, request, "没有此应用");
			return "没有此应用";
		}
		return null;
	}
	
	public String validateSingleRes(Tenant tenant, TenantUser user,
			String systemCode, HttpServletRequest request) {
		String errorMsg = new String();

		int code = getResTenantService().isNeedTenant(systemCode);

		if (code == 2) {
			errorMsg = "没有此应用";
			//this.userAuthSecurityLogUtils.onAuthFailed(user, request, errorMsg);
			return errorMsg;
		}

		if (code == 1) {
			if (tenant == null)
				return "该应用需要有相应权限才能登录";
			TenantRes res;
			try {
				PerformanceLoggerCollector.start("queryTenantRes");
				res = getTenantResService().findByTenantIdAndSystemCode2(user.getTenantId(), systemCode);
				PerformanceLoggerCollector.stop("queryTenantRes");
			} catch (Exception e) {
				logger.error(e.getMessage(), e);
				//this.userAuthSecurityLogUtils.onAuthFailed(user, request,e.getMessage());
				return "查询出错";
			}
			if (res == null) {
				errorMsg = "没有此应用";
				//this.userAuthSecurityLogUtils.onAuthFailed(user, request,errorMsg);
				return errorMsg;
			}

			String checkTenantRes = PropertyUtil.getPropertyByKey("validate.checkTenantRes");
			boolean isCheckTenantRes = Boolean.valueOf(checkTenantRes)
					.booleanValue();
			if (isCheckTenantRes) {
				if (0 == res.getStates()) {
					errorMsg = "应用还未初始化，请先初始化应用";
					//this.userAuthSecurityLogUtils.onAuthFailed(user, request,errorMsg);
					return errorMsg;
				}
				if (2 == res.getStates()) {
					errorMsg = "应用初始化失败";
					//this.userAuthSecurityLogUtils.onAuthFailed(user, request,errorMsg);
					return errorMsg;
				}
			}
			if (user.getTypeId() != 1) {
				try {
					if (!DateUtils.after(res.getEndDate())) {
						errorMsg = "请先续租该应用";
						//this.userAuthSecurityLogUtils.onAuthFailed(user,request, errorMsg);
						return errorMsg;
					}
				} catch (ParseException e) {
					logger.error(e.getMessage(), e);
					//this.userAuthSecurityLogUtils.onAuthFailed(user, request,e.getMessage());
					return "转化出错";
				}
				boolean hasPerssion;
				try {
					PerformanceLoggerCollector.start("queryPermission");
					hasPerssion = getUserPermissionService().havePermission(user.getUserId(), systemCode);
					PerformanceLoggerCollector.stop("queryPermission");
				} catch (Exception e) {
					logger.error(e.getMessage(), e);
					//this.userAuthSecurityLogUtils.onAuthFailed(user, request,e.getMessage());
					return "查询出错";
				}
				if (!hasPerssion) {
					errorMsg = "当前用户无权限";
					//this.userAuthSecurityLogUtils.onAuthFailed(user, request,errorMsg);
					return errorMsg;
				}
			}
		}
		return errorMsg;
	}
	
	private boolean mustModifyDefaultPwd(String tenantId) {
		String sql = "SELECT t.tenant_pwdpolicy from pub_tenant t where t.tenant_id = ?";

		String passwordPolicy = getJdbcTemplate().queryForObject(sql, String.class, tenantId);

		if (StringUtils.isBlank(passwordPolicy)) {
			passwordPolicy = "5c5865ce-cf83-4b0d-bc7d-5fae9da95701";
		}

		sql = "SELECT t.force_modify_default_pwd from pub_passwordlevel t where t.pwdlevel_id = ?";

		String forceModifyDefaultPwd = getJdbcTemplate().queryForObject(sql, String.class, passwordPolicy);


		return !"N".equals(forceModifyDefaultPwd);
	}
}
