package com.yonyou.uap.tenant.utils;

import com.yonyou.uap.tenant.entity.TenantUser;
import org.apache.commons.lang.StringUtils;
import org.springside.modules.security.utils.Digests;
import org.springside.modules.utils.Encodes;

public class PasswordUtils {
	public static final int HASH_INTERATIONS = 1;
	private static final int SALT_SIZE = 8;

	public static String encodebyUserCode(TenantUser user) {
		String userCode = user.getUserCode();
		if (StringUtils.isNotBlank(userCode)) {
			String hashUserCode = encodePasswordUsingSHA(userCode);
			byte[] hashPassword = Digests.sha1(
					(user.getUserPassword() + hashUserCode).getBytes(),
					Encodes.decodeHex(user.getSalt()), HASH_INTERATIONS);

			return Encodes.encodeHex(hashPassword);
		}
		byte[] hashPassword = Digests.sha1(user.getUserPassword().getBytes(),
				Encodes.decodeHex(user.getSalt()), HASH_INTERATIONS);

		return Encodes.encodeHex(hashPassword);
	}

	public static void setSalt(TenantUser user) {
		byte[] salt = Digests.generateSalt(SALT_SIZE);
		user.setSalt(Encodes.encodeHex(salt));
	}

	public static String encodePassword(String password, String salt) {
		byte[] hashPassword = Digests.sha1(password.getBytes(),
				Encodes.decodeHex(salt), HASH_INTERATIONS);
		return Encodes.encodeHex(hashPassword);
	}

	public static String encodePasswordByUserCode(String password, String salt,
			String userCode) {
		if (StringUtils.isNotBlank(userCode)) {
			String hashUserCode = encodePasswordUsingSHA(userCode);
			byte[] hashPassword = Digests.sha1(
					(password + hashUserCode).getBytes(),
					Encodes.decodeHex(salt), HASH_INTERATIONS);

			return Encodes.encodeHex(hashPassword);
		}
		byte[] hashPassword = Digests.sha1(password.getBytes(),
				Encodes.decodeHex(salt), HASH_INTERATIONS);
		return Encodes.encodeHex(hashPassword);
	}

	public static String encodePasswordUsingSHA(String password) {
		byte[] hashPassword = Digests.sha1(password.getBytes());
		String result = Encodes.encodeHex(hashPassword);
		return result;
	}

	public static String encodePasswordUsingSHA(String password, String salt) {
		byte[] hashPassword = Digests.sha1(password.getBytes());
		String shaResult = Encodes.encodeHex(hashPassword);
		byte[] encrytyPassword = Digests.sha1(shaResult.getBytes(),
				Encodes.decodeHex(salt), HASH_INTERATIONS);
		return Encodes.encodeHex(encrytyPassword);
	}

	public static String getSalt() {
		byte[] salt = Digests.generateSalt(SALT_SIZE);
		return Encodes.encodeHex(salt);
	}
}