package com.yonyou.uap.tenant.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.AbstractDistributedTicketRegistry;
import org.springframework.util.Assert;

import com.yonyou.uap.tenant.sendmessage.SendLogoutMessage;

import uap.web.cache.CacheManager;
import uap.web.core.ContextHolder;

public class RedisTicketRegistry extends AbstractDistributedTicketRegistry {
	private static CacheManager cacheManager = null;
	private static final String TICKET_SSO = "ticket_sso";
	private SendLogoutMessage sendlogout = null;

	public SendLogoutMessage getSendlogout() {
		return this.sendlogout;
	}

	public void setSendlogout(SendLogoutMessage sendlogout) {
		this.sendlogout = sendlogout;
	}

	private synchronized CacheManager getCacheManager() {
		if (cacheManager != null) {
			return cacheManager;
		}
		cacheManager = (CacheManager) ContextHolder.getContext().getBean("cacheManager");

		return cacheManager;
	}

	public void addTicket(Ticket ticket) {
		cacheManager = getCacheManager();

		Assert.notNull(ticket, "ticket cannot be null");

		this.logger.debug("Added ticket [{}] to registry.", ticket.getId());
		cacheManager.putTicketCacheAttribute("ticket_sso", ticket.getId(), ticket);
		if ((ticket instanceof ServiceTicket)) {
			TicketGrantingTicket tgtTicket = ticket.getGrantingTicket();
			if (tgtTicket != null) {
				Ticket oldTgtTicket = getTicket(tgtTicket.getId());
				if (oldTgtTicket != null) {
					cacheManager.putTicketCacheAttribute(TICKET_SSO, tgtTicket.getId(), tgtTicket);

					cacheManager.putTicketCacheAttribute("SSO_USERNAME_" + tgtTicket.getAuthentication().getPrincipal().getId(), tgtTicket.getId(),tgtTicket.getId());
				}
			}
		}
	}

	public Ticket getTicket(String ticketId) {
		cacheManager = getCacheManager();

		if (ticketId == null) {
			return null;
		}

		this.logger.debug("Attempting to retrieve ticket [{}]", ticketId);
		Ticket ticket = (Ticket) cacheManager.getTicketCacheAttribute(TICKET_SSO, ticketId);

		if (ticket != null) {
			this.logger.debug("Ticket [{}] found in registry.", ticketId);
		}
		return ticket;
	}

	public boolean deleteTicket(String ticketId) {
		cacheManager = getCacheManager();

		if (ticketId == null) {
			return false;
		}

		Ticket ticket = getTicket(ticketId);
		if (ticket == null) {
			return false;
		}

		if ((ticket instanceof TicketGrantingTicket)) {
			sendLogout(ticket);
		}
		this.logger.debug("Removing ticket [{}] from the registry.", ticket);
		return cacheManager.removeCacheAttribute(TICKET_SSO, ticketId);
	}

	private void sendLogout(Ticket ticket) {
		this.sendlogout.sendEventMessage(ticket);
	}

	public Collection<Ticket> getTickets() {
		Map<String, Ticket> tcache = getTicketsFromRedis();

		return Collections.unmodifiableCollection(tcache.values());
	}

	protected void updateTicket(Ticket ticket) {
		addTicket(ticket);
	}

	protected boolean needsCallback() {
		return true;
	}

	private Map<String, Ticket> getTicketsFromRedis() {
		cacheManager = getCacheManager();
		Map<String, Object> tickmap = cacheManager.getAllTicketAttrCache(TICKET_SSO);

		Map<String,Ticket> tcache = new ConcurrentHashMap<String,Ticket>();

		for (Map.Entry<String,Object> entry : tickmap.entrySet()) {
			String key = (String) entry.getKey();
			Ticket ticket = (Ticket) entry.getValue();
			tcache.put(key, ticket);
		}

		return tcache;
	}
}