package com.yonyou.uap.tenant.utils;

import java.util.List;

import org.springside.modules.nosql.redis.JedisTemplate;
import org.springside.modules.nosql.redis.pool.JedisPool;

import com.yonyou.uap.tenant.web.filter.PerformanceLoggerCollector;

import redis.clients.jedis.exceptions.JedisException;

public class SsoJedisTemplate extends JedisTemplate {
	
	public SsoJedisTemplate(JedisPool jedisPool) {    
		super(jedisPool);
	}

	public <T> T execute(JedisTemplate.JedisAction<T> jedisAction) throws JedisException {
		PerformanceLoggerCollector.start("redis", "JedisAction");
		T result = super.execute(jedisAction);
		PerformanceLoggerCollector.stop("redis");
		return result;
	}

	public void execute(JedisTemplate.JedisActionNoResult jedisAction) throws JedisException {
		PerformanceLoggerCollector.start("redis", "JedisActionNoResult");
		super.execute(jedisAction);
		PerformanceLoggerCollector.stop("redis");
	}

	public List<Object> execute(JedisTemplate.PipelineAction pipelineAction) throws JedisException {
		PerformanceLoggerCollector.start("redis", "PipelineAction");
		List<Object> result = super.execute(pipelineAction);
		PerformanceLoggerCollector.stop("redis");
		return result;
	}

	public void execute(JedisTemplate.PipelineActionNoResult pipelineAction) throws JedisException {
		PerformanceLoggerCollector.start("redis", "PipelineActionNoResult");
		super.execute(pipelineAction);
		PerformanceLoggerCollector.stop("redis");
	}
}     