package com.yonyou.uap.tenant.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.security.auth.login.FailedLoginException;
import javax.validation.constraints.NotNull;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;
import org.jasig.cas.adaptors.jdbc.AbstractJdbcUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.ContinueRegisterException;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.ModifyPWFailedException;
import org.jasig.cas.authentication.NeedModifyPWException;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.handler.PasswordEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springside.modules.mapper.JsonMapper;
import org.springside.modules.security.utils.Digests;
import org.springside.modules.utils.Encodes;

import com.alibaba.fastjson.JSONObject;
import com.yonyou.uap.tenant.log.CasLog;
import com.yonyou.uap.tenant.web.filter.PerformanceLoggerCollector;
import com.yonyouccs.bean.AuthResult;
import com.yonyouccs.bean.JitGatewayUtilBean;
import com.yonyouccs.config.CaConfig;
import com.yonyouccs.gateway.util.JitGatewayUtil;
import com.yonyouccs.gateway.util.JitGatewayUtil.AuthConstant;

import sun.misc.BASE64Encoder;
import uap.web.cache.CacheManager;
import uap.web.core.ContextHolder;
import uap.web.utils.RSAUtils;

@SuppressWarnings("rawtypes")
public class TenantAuthenticationHandler extends AbstractJdbcUsernamePasswordAuthenticationHandler implements InitializingBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String SQL_PREFIX = "select count(1) from ";
    private static final String USERPWD_LOGIN_TYPE = "0"; //用户名密码登录
    private static final String PHONEVER_LOGIN_TYPE = "1"; //手机号登录
    private static final String QR_LOGIN_TYPE = "2";//硬件key登录
    
    @NotNull
    private String fieldUser;
    @NotNull
    private String fieldPassword;
    @NotNull
    private String tableUsers;
    private String sql;

    public TenantAuthenticationHandler() {
    }

    private CasLog getCasLog() {
        CasLog casLog = (CasLog)ContextHolder.getContext().getBean("securityLog");
        return casLog;
    }

    protected final HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        PerformanceLoggerCollector.start("authenticateUsernamePasswordInternal");
        String is_security_ca = credential.getIs_security_ca();
        RequestContextHolder.getRequestContext().getFlowScope().put("is_security_ca", is_security_ca);
        
        
        if(QR_LOGIN_TYPE.equals(is_security_ca)) { //证书登录
            // 封装认证请求数据bean
            JitGatewayUtilBean jitGatewayUtilBean = new JitGatewayUtilBean();
            // 设置认证方式、报文token、session中认证原文、客户端认证原文、认证数据包、远程地址
            jitGatewayUtilBean.setAuthMode(credential.getAuthMode());
            jitGatewayUtilBean.setToken("");
            CacheManager cacheManager = (CacheManager) ContextHolder.getContext().getBean("cacheManager");
            jitGatewayUtilBean.setOriginal_data(cacheManager.get(JitGatewayUtil.AuthConstant.KEY_ORIGINAL_DATA).toString());
            jitGatewayUtilBean.setOriginal_jsp(credential.getOriginal());
            jitGatewayUtilBean.setSigned_data(credential.getSigned_data());
            jitGatewayUtilBean.setRemoteAddr("127.0.0.1");
            
            AuthResult authResult = auth(jitGatewayUtilBean);
            if(authResult.isSuccess()){
            	String idCode = null;
            	String subjectDn = authResult.getSubjectDN();
            	if(org.apache.commons.lang.StringUtils.isNotBlank(subjectDn)) {
            		String[] dnArr = subjectDn.split(",");
            		for(String dnString:dnArr){
            			String keydn = dnString.split("=")[0].trim();
            			String keyValue = dnString.split("=")[1].trim();
            			if("T".equals(keydn)) {
            				idCode = keyValue;
            			}
            		}
            	}
            	
            	if(org.apache.commons.lang.StringUtils.isBlank(idCode)) {
            		this.getCasLog().recordLog(credential, "SSO_LOGININ", "FAILED", new String[]{"CA证书不合法"});
                    RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", "CA证书不合法");
                    throw new PreventedException("证书不合法", new Throwable());
            	}else{
            		String sql = "SELECT t.* from pub_tenant_user t where t.ca_code = ? and t.dr = 0";
    				List resultList = getJdbcTemplate().queryForList(sql, idCode);
                	if(resultList.size() > 0) {
                		Map resultMap = (Map) resultList.get(0);
                		credential.setUsername(resultMap.get("user_code").toString());
                		credential.setPassword(resultMap.get("user_password").toString());
                	}else{
                		this.getCasLog().recordLog(credential, "SSO_LOGININ", "FAILED", new String[]{"该CA证书找不对对应的人"});
                        RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", "该CA证书找不对对应的人");
                        throw new PreventedException("该证书找不对对应的人", new Throwable());
                	}
            	}
            }else{
            	this.getCasLog().recordLog(credential, "SSO_LOGININ", "FAILED", new String[]{"CA证书不合法"});
                RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", "CA证书不合法");
                throw new PreventedException("证书不合法", new Throwable());
            }
        }else if(PHONEVER_LOGIN_TYPE.equals(is_security_ca)){ //手机号验证码登录
        	if(StringUtils.isBlank(credential.getUserphone())) {
        		this.getCasLog().recordLog(credential, "SSO_LOGININ", "FAILED", new String[]{"用户手机号不能为空！"});
                RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", "用户手机号不能为空！");
                throw new PreventedException("用户手机号不能为空！", new Throwable());
        	}
        	if(StringUtils.isBlank(credential.getUservertycode())) {
        		this.getCasLog().recordLog(credential, "SSO_LOGININ", "FAILED", new String[]{"验证码不能为空！"});
                RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", "验证码不能为空！");
                throw new PreventedException("验证码不能为空！", new Throwable());
        	}
        	String validateMsgUrl = CasPropertyUtil.getPropertyByKey("validatePhoneCode.url");
        	validateMsgUrl = validateMsgUrl+"?phone="+credential.getUserphone()+"&validate="+credential.getUservertycode();
        	JSONObject param=new JSONObject();
    		param.put("phone", credential.getUserphone());
    		param.put("validate", credential.getUservertycode());
        	String httpResult = HttpRequest.sendPost2(validateMsgUrl, param.toString());
        	JSONObject obj=JSONObject.parseObject(httpResult);
        	String status=obj.getString("status");
    		String msg=obj.getString("msg");
    		if ("0".equals(status)) {
    			this.getCasLog().recordLog(credential, "SSO_LOGININ", "FAILED", new String[]{msg});
                RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", msg);
                throw new PreventedException(msg, new Throwable());
    		}else{
    			String sql = "SELECT t.* from pub_tenant_user t where t.user_mobile = ? and t.dr = 0";
				List resultList = getJdbcTemplate().queryForList(sql, credential.getUserphone());
				if(resultList != null && resultList.size() == 1) {
            		Map resultMap = (Map) resultList.get(0);
            		credential.setUsername(resultMap.get("user_code").toString());
            		credential.setPassword(resultMap.get("user_password").toString());
            	}else{
            		this.getCasLog().recordLog(credential, "SSO_LOGININ", "FAILED", new String[]{"该手机号在系统中不存在"});
                    RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", "该手机号在系统中不存在");
                    throw new PreventedException("该手机号在系统中不存在", new Throwable());
            	}
    		}
        }
        
        if(StringUtils.isBlank(credential.getUsername()) || StringUtils.isBlank(credential.getPassword())) {
        	this.getCasLog().recordLog(credential, "SSO_LOGININ", "FAILED", new String[]{"用户名或密码不能为空！"});
            RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", "用户名或密码不能为空！");
            throw new PreventedException("用户名或密码不能为空！", new Throwable());
        }
        
        String username = credential.getUsername();
        if (credential.isFirstSuccess()) {
            return this.createHandlerResult(credential, this.principalFactory.createPrincipal(username), (List)null);
        } else {
            String newpass = credential.getNewpass();
            if (newpass != null && !newpass.equals("null")) {
                return this.changeUserPwd(credential);
            } else if (1 == credential.getIsAutoLogin()) {
                return this.authenticateUsernamePasswordInternal_autoLogin(credential);
            } else {
                if (!StringUtils.isEmpty(credential.getOpenid())) {
                    HandlerResult result = this.authenticateUsernamePasswordInternal_weixin(credential);
                    if (result != null) {
                        return result;
                    }

                    if (credential.getOpenid().equalsIgnoreCase(credential.getUsername())) {
                        credential.setUsername("");
                        credential.setPassword("");
                        RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", "未绑定微信账户");
                        throw new PreventedException("登录失败：未绑定微信账户", new Throwable());
                    }
                }

                if (StringUtils.isEmpty(credential.getVerify_code())) {
                    return this.authenticateUsernamePasswordInternal_default(credential);
                } else {
                    String result = "false";

                    try {
                        PerformanceLoggerCollector.start("UserValidate.validate");
                        result = UserValidate.validate(credential, this.getJdbcTemplate());
                        PerformanceLoggerCollector.stop("UserValidate.validate");
                        if (org.apache.commons.lang3.StringUtils.isBlank(result)) {
                            this.getCasLog().recordLog(credential, "SSO_LOGININ", "FAILED", new String[]{"系统连接异常"});
                            RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", "系统连接异常");
                        }

                        PerformanceLoggerCollector.start("JSONObject.fromObject");
                        JSONObject jsonObj = JSONObject.parseObject(result);
                        PerformanceLoggerCollector.stop("JSONObject.fromObject");
                        if ("2".equalsIgnoreCase(String.valueOf(jsonObj.get("status")))) {

                            JSONObject user = jsonObj.getJSONObject("user");
                            if (user != null) {
                                String userId = user.getString("userId");
                                String userMobile = user.getString("userMobile");
                                String userCode = user.getString("userCode");

                                if (userId != null) {
                                    String sql = "SELECT t.salt from pub_tenant_user t where t.user_id = ?";

                                    String salt = getJdbcTemplate().queryForObject(sql, String.class, userId);

                                    if (userMobile != null && salt != null) {
                                        credential.setPhoneNum(userMobile);
                                        credential.setSalt(salt);
                                        credential.setUserCode(userCode);
                                    }
                                }


                            }

                            throw new NeedModifyPWException(username + " need modify password.");
                        }

                        if ("0".equalsIgnoreCase(String.valueOf(jsonObj.get("status")))) {
                            this.getCasLog().recordLog(credential, "SSO_LOGININ", "FAILED", new String[]{String.valueOf(jsonObj.get("msg"))});
                            RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", jsonObj.get("msg"));
                            throw new PreventedException("user lock " + username, new Throwable());
                        }

                        if ("4".equalsIgnoreCase(String.valueOf(jsonObj.get("status")))) {
//                            RequestContextHolder.getRequestContext().getFlowScope().put("userTel", jsonObj.get("userTel"));
//                            String url = CasPropertyUtil.getPropertyByKey("register.url");
//                            RequestContextHolder.getRequestContext().getFlowScope().put("registerurl", url);
//                            RequestContextHolder.getRequestContext().getFlowScope().put("returnservice", credential.getService());
//                            throw new ContinueRegisterException("need to register.");
                            RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", "登录失败，请到<a href=\"https://www.yonyouccs.com/icop-website/signin\">用友建筑云官网</a>个人中心完成企业资质录入。");
                            throw new PreventedException("登录失败，请到官网个人中心完成企业资质录入", new Throwable());
                        }

                        PerformanceLoggerCollector.start("parmas");
                        HashMap<String, Object> attr = new HashMap();
                        Object usertype = jsonObj.get("usertype");
                        attr.put("userType", usertype);
                        JSONObject userobj = (JSONObject)jsonObj.get("user");
                        String userId = null;
                        String userCode = null;
                        if (userobj != null) {
                            String tenant = userobj.get("tenantId").toString();
                            String tenantid = tenant == null ? null : tenant;
                            userId = (String)userobj.get("userId");
                            attr.put("userId", userId);
                            String typeId = String.valueOf(userobj.get("typeId"));
                            attr.put("typeAlias", typeId);
                            userCode = (String)userobj.get("userCode");
                            attr.put("userCode", userCode);
                            credential.setTenantid(tenantid);
                            credential.setAttrparam(attr);
                        }

                        PerformanceLoggerCollector.stop("parmas");
                        this.saveWeixin(credential, userCode);
                        if ("1".equalsIgnoreCase(String.valueOf(jsonObj.get("status")))) {
                            this.writeLastLoginDate(userCode);
                        }
                    } catch (Exception var14) {
                        this.getCasLog().recordLog(credential, "SSO_LOGININ", "FAILED", new String[0]);
                        if (var14 instanceof NeedModifyPWException) {
                            throw new NeedModifyPWException(username + " need modify password.");
                        }

                        if (var14 instanceof ContinueRegisterException) {
                            throw new ContinueRegisterException(username + " need contine to register");
                        }

                        this.logger.error(var14.getMessage(), var14);
                        throw new PreventedException("SQL exception while executing query for " + username, var14);
                    }

                    credential.setFirstSuccess(true);
                    this.getCasLog().recordLog(credential, "SSO_LOGININ", "SUCCESS", new String[0]);
                    PerformanceLoggerCollector.stop("authenticateUsernamePasswordInternal");
                    return this.createHandlerResult(credential, this.principalFactory.createPrincipal(username), (List)null);
                }
            }
        }
    }

    private HandlerResult changeUserPwd(UsernamePasswordCredential credential) throws ModifyPWFailedException {
        try {
            String result = UserValidate.modifyPW(credential);
            JsonMapper objectMapper = new JsonMapper();
            Map<String, Object> map = (Map)objectMapper.fromJson(result, Map.class);
            if (map.get("status").toString().equals("1")) {
                credential.setPassword(credential.getNewpass());
                credential.setNewpass((String)null);
                credential.setFirstSuccess(true);
                HashMap<String, Object> attr = new HashMap();
                Object usertype = map.get("usertype");
                attr.put("userType", usertype);
                Object userobj = map.get("user");
                String tenantid = (String)((HashMap)userobj).get("tenantId");
                String userId = (String)((Map)userobj).get("userId");
                attr.put("userId", userId);
                String userCode = (String)((Map)userobj).get("userCode");
                attr.put("userCode", userCode);
                String typeId = String.valueOf(((Map)userobj).get("typeId"));
                attr.put("typeAlias", typeId);
                credential.setTenantid(tenantid);
                credential.setAttrparam(attr);
                this.writeLastLoginDate(userCode);
            }

            if (map.get("status").toString().equals("0")) {
                RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", map.get("msg"));
                RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_fail", true);
                throw new ModifyPWFailedException(credential.getUsername() + "   modify password failed.");
            }
        } catch (Exception var12) {
            this.logger.error(var12.getMessage(), var12);
            this.getCasLog().recordLog(credential, "SSO_MODIFY_PASSWORD", "FAILED", new String[0]);
            throw new ModifyPWFailedException(credential.getUsername() + "   modify password failed.");
        }

        this.getCasLog().recordLog(credential, "SSO_MODIFY_PASSWORD", "SUCCESS", new String[0]);
        return this.createHandlerResult(credential, this.principalFactory.createPrincipal(credential.getUsername()), (List)null);
    }

    protected final HandlerResult authenticateUsernamePasswordInternal_default(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        String username = credential.getUsername();
        PasswordEncoder passwordEncoder = this.getPasswordEncoder();
        String encodepassword = null;
        String salt = null;
        String encyptedPassword;
        String idsql;

        String encodeDefaultPwd = null;

        if (passwordEncoder instanceof TenantPasswordEncoder) {
            try {
                String saltSQL = "select salt from " + this.tableUsers + " WHERE " + this.fieldUser + " = ? ";
                salt = this.getJdbcTemplate().queryForObject(saltSQL, String.class, username);

                credential.setSalt(salt);
                
                if(USERPWD_LOGIN_TYPE.equals(credential.getIs_security_ca())) {
                	idsql = credential.getPassword();
                	idsql = idsql.replace("_encrypted", "");
                	idsql = RSAUtils.decryptStringByJs(idsql);
                	encodepassword = ((TenantPasswordEncoder)passwordEncoder).encode(salt, idsql, username);
                }else{
                	encodepassword = credential.getPassword();
                }
            } catch (Exception var10) {
                this.logger.error(var10.getMessage(), var10);
            }
        } else {
            encodepassword = passwordEncoder.encode(credential.getPassword());
        }

        encyptedPassword = encodepassword;

        int count;
        try {
            count = this.getJdbcTemplate().queryForObject(this.sql, Integer.class, username, encyptedPassword);
        } catch (DataAccessException var9) {
            this.logger.error(var9.getMessage(), var9);
            throw new PreventedException("SQL exception while executing query for " + username, var9);
        }

        if (count == 0) {
            throw new FailedLoginException(username + " not found with SQL query.");
        } else {
            idsql = " select tenant_id, user_mobile from pub_tenant_user where user_code=? ";
            Map<String, Object> tenantUser = this.getJdbcTemplate().queryForMap(idsql, username);

            String tenantid = null;
            String userMobile = null;

            if (tenantUser.get("tenant_id") != null) {
                tenantid = (String) tenantUser.get("tenant_id");
            }

            if (tenantUser.get("user_mobile") != null) {
                userMobile = (String) tenantUser.get("user_mobile");
            }

            credential.setTenantid(tenantid);
            credential.setPhoneNum(userMobile);

            String tenantDefaultPwdSQL = "select defaultpwd from pub_defaultpwd where tenant_id=?";
            String defaultPwd = this.getJdbcTemplate().queryForObject(tenantDefaultPwdSQL, String.class, tenantid);

            if (defaultPwd != null) {
                String sha1DefaultPwd = Encodes.encodeHex(Digests.sha1(defaultPwd.getBytes()));

                if (passwordEncoder instanceof TenantPasswordEncoder) {
                    encodeDefaultPwd = ((TenantPasswordEncoder)passwordEncoder).encode(salt, sha1DefaultPwd, username);
                } else {
                    encodeDefaultPwd = passwordEncoder.encode(sha1DefaultPwd);
                }
            }

            if (encyptedPassword != null && encyptedPassword.equals(encodeDefaultPwd)) {
                throw new NeedModifyPWException(username);
            }

            return this.createHandlerResult(credential, this.principalFactory.createPrincipal(username), (List)null);
        }
    }

    protected final HandlerResult authenticateUsernamePasswordInternal_weixin(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        String openid = credential.getOpenid();
        String userCode = null;
        String tenant_id = null;

        try {
            String mysql = "select user_code,tenant_id from pub_user_weixin WHERE openid= ? ";
            List<Map<String, Object>> list = this.getJdbcTemplate().queryForList(mysql, new Object[]{openid});
            if (list != null && list.size() > 0) {
                userCode = (String)((Map)list.get(0)).get("user_code");
                tenant_id = (String)((Map)list.get(0)).get("tenant_id");
            }

            if (!StringUtils.isEmpty(userCode)) {
                String sql = "select * from pub_tenant_user where user_code= ? ";
                Map result = this.getJdbcTemplate().queryForMap(sql, new Object[]{userCode});
                String user_id = MapUtils.getString(result, "user_id");
                String user_code = MapUtils.getString(result, "user_code");
                int type_id = MapUtils.getInteger(result, "type_id").intValue();
                HashMap<String, Object> attr = new HashMap();
                attr.put("userType", type_id);
                attr.put("userId", user_id);
                attr.put("typeAlias", type_id);
                attr.put("userCode", user_code);
                credential.setTenantid(tenant_id);
                credential.setAttrparam(attr);
                this.writeLastLoginDate(user_code);
                return this.createHandlerResult(credential, this.principalFactory.createPrincipal(userCode), (List)null);
            } else {
                return null;
            }
        } catch (Exception var13) {
            this.logger.error(var13.getMessage(), var13);
            throw new PreventedException("SQL exception while executing query for " + openid, var13);
        }
    }

    private void saveWeixin(UsernamePasswordCredential credential, String user_code) {
        String openid = credential.getOpenid();
        String tenantid = credential.getTenantid();
        if (!StringUtils.isEmpty(openid) && !StringUtils.isEmpty(user_code)) {
            String mysql = "select user_code from pub_user_weixin WHERE openid= ? ";
            List<Map<String, Object>> list = this.getJdbcTemplate().queryForList(mysql, new Object[]{openid});
            String userCode = null;
            if (list != null && list.size() > 0) {
                userCode = (String)((Map)list.get(0)).get("user_code");
            }

            if (StringUtils.isEmpty(userCode)) {
                String addSql = "insert into pub_user_weixin (openid,user_code,tenant_id) value(?,?,?);";
                this.getJdbcTemplate().update(addSql, new Object[]{openid, user_code, tenantid});
            }
        }

    }

    protected final HandlerResult authenticateUsernamePasswordInternal_autoLogin(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        String username = credential.getUsername();
        String sql = "select * from pub_tenant_user where user_code= ? ";
        Map result = this.getJdbcTemplate().queryForMap(sql, new Object[]{username});
        String tenant_id = MapUtils.getString(result, "tenant_id");
        String user_id = MapUtils.getString(result, "user_id");
        String user_code = MapUtils.getString(result, "user_code");
        int type_id = MapUtils.getInteger(result, "type_id").intValue();
        HashMap<String, Object> attr = new HashMap();
        attr.put("userType", type_id);
        attr.put("userId", user_id);
        attr.put("typeAlias", type_id);
        attr.put("userCode", user_code);
        credential.setTenantid(tenant_id);
        credential.setAttrparam(attr);
        this.writeLastLoginDate(user_code);
        return this.createHandlerResult(credential, this.principalFactory.createPrincipal(username), (List)null);
    }

    public void afterPropertiesSet() throws Exception {
        this.sql = SQL_PREFIX + this.tableUsers + " WHERE " + this.fieldUser + " = ? AND " + this.fieldPassword + " = ?";
    }

    public final void setFieldPassword(String fieldPassword) {
        this.fieldPassword = fieldPassword;
    }

    public final void setFieldUser(String fieldUser) {
        this.fieldUser = fieldUser;
    }

    public final void setTableUsers(String tableUsers) {
        this.tableUsers = tableUsers;
    }

    private void writeLastLoginDate(String userCode) {
        if (!StringUtils.isEmpty(userCode)) {
            String updateSql = "update pub_tenant_user set last_login_date =? where user_code=?;";
            this.getJdbcTemplate().update(updateSql, new Object[]{DateUtils.getCurrectTime(), userCode});
        }

    }
    
    /**
     * 身份认证
     * 
     * @return
     */
    private AuthResult auth(JitGatewayUtilBean jitGatewayUtilBean) {
        AuthResult authResult = new AuthResult();
        // 成功标记
        boolean isSuccess = true;
        String errCode = null;
        String errDesc = null;
        String original_data_base64 = null;

        // 认证地址、应用标识
        String authURL = jitGatewayUtilBean.getAuthURL();
        // String appId = configMap.get(ConfigConstant.KEY_APP_ID);
        // String appId = configMap.get(ConfigConstant.KEY_APP_ID).toString();
        String appId = CaConfig.appId;
        
        // 校验应用标识或网关认证地址不可为空
        if (!JitGatewayUtil.isNotNull(appId) || !JitGatewayUtil.isNotNull(authURL)) {
            isSuccess = false;
            errDesc = "应用标识或网关认证地址不可为空";
            logger.info("应用标识或网关认证地址不可为空\n");
        }
        logger.info("应用标识及网关的认证地址读取成功！\n应用标识：" + appId + "\n认证地址：" + authURL + "\n");

        // 服务端验证认证原文
        if (isSuccess && !AuthConstant.MSG_AUTH_MODE_QRCODE_VALUE.equalsIgnoreCase(jitGatewayUtilBean.getAuthMode())) {
            logger.info("服务端验证认证原文开始");
            if (JitGatewayUtil.isNotNull(jitGatewayUtilBean.getOriginal_data())
                    && JitGatewayUtil.isNotNull(jitGatewayUtilBean.getSigned_data())
                    && JitGatewayUtil.isNotNull(jitGatewayUtilBean.getOriginal_jsp())) {
                // 服务端验证认证原文
                if (!jitGatewayUtilBean.getOriginal_data().equalsIgnoreCase(jitGatewayUtilBean.getOriginal_jsp())) {
                    isSuccess = false;
                    errDesc = "服务端验证认证原文失败:客户端提供的认证原文与服务端的不一致";
                    logger.info(errDesc);
                } else {
                    // 生成随机密钥
                    original_data_base64 = new BASE64Encoder().encode(jitGatewayUtilBean.getOriginal_jsp().getBytes());
                    logger.info("服务端验证认证原文:服务端验证认证原文成功！\n认证原文：" + jitGatewayUtilBean.getOriginal_jsp()
                            + "\n认证请求包：" + jitGatewayUtilBean.getSigned_data() + "\n");
                }
            } else {
                isSuccess = false;
                errDesc = "服务端验证认证原文失败:证书认证数据不完整";
                logger.info("服务端验证认证原文失败:证书认证数据不完整！\n");
            }
            logger.info("服务端验证认证原文结束");
        }

        // 请求网关进行认证
        try {
            byte[] messagexml = null;
            if (isSuccess) {
                logger.info("组装认证请求报文开始");
                // 组装认证请求报文数据开始
                Document reqDocument = DocumentHelper.createDocument();
                Element root = reqDocument.addElement(JitGatewayUtil.CommonConstant.MSG_ROOT);
                Element requestHeadElement = root.addElement(JitGatewayUtil.CommonConstant.MSG_HEAD);
                Element requestBodyElement = root.addElement(JitGatewayUtil.CommonConstant.MSG_BODY);

                // 组装报文头信息 ,组装认证xml文件时，进行判断，如果配置调用应用服务器生成原文，则生成xml
                // version版本为1.0，
                // 如果配置从网关生成原文，则生成xml version版本为1.1
                // if("2".equals(configMap.get(ConfigConstant.KEY_RANDOM_FROM))){
                if ("2".equals(CaConfig.randomFrom)) {
                    requestHeadElement.addElement(JitGatewayUtil.CommonConstant.MSG_VSERSION)
                            .setText(JitGatewayUtil.CommonConstant.MSG_VSERSION_VALUE_11);
                } else {
                    requestHeadElement.addElement(JitGatewayUtil.CommonConstant.MSG_VSERSION)
                            .setText(JitGatewayUtil.CommonConstant.MSG_VSERSION_VALUE_10);
                }

                // 服务类型
                requestHeadElement.addElement(JitGatewayUtil.CommonConstant.MSG_SERVICE_TYPE)
                        .setText(AuthConstant.MSG_SERVICE_TYPE_VALUE);

                // 组装报文体信息
                // 组装客户端信息
                Element clientInfoElement = requestBodyElement.addElement(AuthConstant.MSG_CLIENT_INFO);
                Element clientIPElement = clientInfoElement.addElement(AuthConstant.MSG_CLIENT_IP);
                clientIPElement.setText(jitGatewayUtilBean.getRemoteAddr());

                // 组装应用标识信息
                requestBodyElement.addElement(JitGatewayUtil.CommonConstant.MSG_APPID).setText(appId);
                Element authenElement = requestBodyElement.addElement(AuthConstant.MSG_AUTH);
                Element authCredentialElement = authenElement.addElement(AuthConstant.MSG_AUTHCREDENTIAL);

                // 组装证书认证信息
                if (AuthConstant.MSG_AUTH_MODE_CERT_VALUE.equalsIgnoreCase(jitGatewayUtilBean.getAuthMode())) {
                    authCredentialElement.addAttribute(AuthConstant.MSG_AUTH_MODE,
                            AuthConstant.MSG_AUTH_MODE_CERT_VALUE);
                    authCredentialElement.addElement(AuthConstant.MSG_DETACH)
                            .setText(jitGatewayUtilBean.getSigned_data());
                    authCredentialElement.addElement(JitGatewayUtil.CommonConstant.MSG_ORIGINAL)
                            .setText(original_data_base64);
                } else if (AuthConstant.MSG_AUTH_MODE_QRCODE_VALUE.equalsIgnoreCase(jitGatewayUtilBean.getAuthMode())) {
                    authCredentialElement.addAttribute(AuthConstant.MSG_AUTH_MODE,
                            AuthConstant.MSG_AUTH_MODE_QRCODE_VALUE);
                    authCredentialElement.addElement(AuthConstant.MSG_TOKEN).setText(jitGatewayUtilBean.getToken());
                    authCredentialElement.addElement(AuthConstant.MSG_QRCODE).setText(jitGatewayUtilBean.getQrcode());
                }

                // 是否检查访问控制状态
                requestBodyElement.addElement(AuthConstant.MSG_ACCESS_CONTROL).
                // setText(configMap.get(ConfigConstant.KEY_ACCESS_CONTROL));
                // setText(configMap.get(ConfigConstant.KEY_ACCESS_CONTROL).toString());
                        setText(String.valueOf(CaConfig.accessControl));
                // 组装属性查询列表信息
                Element attributesElement = requestBodyElement.addElement(AuthConstant.MSG_ATTRIBUTES);
                attributesElement.addAttribute(AuthConstant.MSG_ATTRIBUTE_TYPE, AuthConstant.MSG_ATTRIBUTE_TYPE_ALL);
                StringBuffer reqMessageData = new StringBuffer();
                try {
                    ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                    XMLWriter writer = new XMLWriter(outStream);
                    writer.write(reqDocument);
                    messagexml = outStream.toByteArray();

                    reqMessageData.append("请求内容开始！\n");
                    reqMessageData.append(outStream.toString() + "\n");
                    reqMessageData.append("请求内容结束！\n");
                    logger.info(reqMessageData.toString() + "\n");
                } catch (Exception e) {
                    isSuccess = false;
                    errDesc = "组装认证请求报文出现异常";
                    logger.info("组装认证请求报文出现异常" + e.getMessage());
                }
                logger.info("组装认证请求报文结束");
            }

            // 创建与网关的HTTP连接，发送认证请求报文，并接收认证响应报文
            // 创建与网关的HTTP连接 开始
            int statusCode = 500;
            HttpClient httpClient = null;
            PostMethod postMethod = null;
            if (isSuccess) {
                logger.info("向网关发送认证请求开始");
                // HTTPClient对象
                httpClient = new HttpClient();
                postMethod = new PostMethod(authURL);
                postMethod.setRequestHeader("Connection", "close");

                // 设置报文传送的编码格式
                postMethod.setRequestHeader("Content-Type", "text/xml;charset=UTF-8");
                // 设置发送认证请求内容开始
                postMethod.setRequestBody(new ByteArrayInputStream(messagexml));
                // 设置发送认证请求内容结束
                // 执行postMethod
                try {
                    URL url = JitGatewayUtil.protocol(authURL);
                    // 发送通讯报文与网关通讯
                    statusCode = httpClient.executeMethod(postMethod);
                    if (url != null && "https".equals(url.getProtocol())) {
                        Protocol.unregisterProtocol("https");
                    }
                } catch (Exception e) {
                    isSuccess = false;
                    errCode = String.valueOf(statusCode);
                    errDesc = e.getMessage();
                    logger.info("向网关发送认证请求失败：与网关连接出现异常:" + errDesc);
                    postMethod.releaseConnection();
                    httpClient.getHttpConnectionManager().closeIdleConnections(0);
                    httpClient = null;
                    String errorJdkMess = JitGatewayUtil.errorJdkMess(e);
                    if (errorJdkMess != null) {
                        errDesc = errorJdkMess;
                    }
                    throw e;
                }
                logger.info("向网关发送认证请求结束");
            }

            // 读取网关返回的认证响应报文
            StringBuffer respMessageData = new StringBuffer();
            String respMessageXml = null;
            if (isSuccess) {
                logger.info("读取网关返回的认证响应报文开始");
                // 当返回200或500状态时处理业务逻辑
                if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_INTERNAL_SERVER_ERROR) {
                    // 从头中取出转向的地址
                    try {
                        // 接收通讯报文并处理开始
                        byte[] inputstr = postMethod.getResponseBody();

                        ByteArrayInputStream ByteinputStream = new ByteArrayInputStream(inputstr);
                        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                        int ch = 0;
                        try {
                            while ((ch = ByteinputStream.read()) != -1) {
                                int upperCh = (char) ch;
                                outStream.write(upperCh);
                            }
                        } catch (Exception e) {
                            isSuccess = false;
                            errDesc = e.getMessage();
                        }

                        if (isSuccess) {
                            // 200 表示返回处理成功
                            if (statusCode == HttpStatus.SC_OK) {
                                respMessageData.append("响应内容开始！\n");
                                respMessageData.append(new String(outStream.toByteArray(), "UTF-8") + "\n");
                                respMessageData.append("响应内容结束！\n");
                                respMessageXml = new String(outStream.toByteArray(), "UTF-8");
                            } else {
                                // 500 表示返回失败，发生异常
                                respMessageData.append("响应500内容开始！\n");
                                respMessageData.append(new String(outStream.toByteArray()) + "\n");
                                respMessageData.append("响应500内容结束！\n");
                                isSuccess = false;
                                errCode = String.valueOf(statusCode);
                                errDesc = new String(outStream.toByteArray());
                            }
                            logger.info(respMessageData.toString());
                        }
                        // 接收通讯报文并处理结束
                    } catch (IOException e) {
                        isSuccess = false;
                        errCode = String.valueOf(statusCode);
                        errDesc = e.getMessage();
                        logger.info("读取网关返回的认证响应报文出现异常:" + errDesc);
                    } finally {
                        if (httpClient != null) {
                            postMethod.releaseConnection();
                            httpClient.getHttpConnectionManager().closeIdleConnections(0);
                        }
                    }
                }
                logger.info("读取网关返回的认证响应报文结束");
            }

            // 服务端处理(解析网关返回的认证响应报文)
            Document respDocument = null;
            Element headElement = null;
            Element bodyElement = null;
            if (isSuccess) {
                logger.info("解析网关返回的认证响应报文开始");
                // 特殊字符'&'处理
                respMessageXml = respMessageXml.replaceAll("&", "&amp;");
                respDocument = DocumentHelper.parseText(respMessageXml);

                headElement = respDocument.getRootElement().element(JitGatewayUtil.CommonConstant.MSG_HEAD);
                bodyElement = respDocument.getRootElement().element(JitGatewayUtil.CommonConstant.MSG_BODY);

                // 解析报文头
                if (headElement != null) {
                    boolean state = Boolean
                            .valueOf(headElement.elementTextTrim(JitGatewayUtil.CommonConstant.MSG_MESSAGE_STATE));
                    if (state) {
                        isSuccess = false;
                        errCode = headElement.elementTextTrim(JitGatewayUtil.CommonConstant.MSG_MESSAGE_CODE);
                        errDesc = headElement.elementTextTrim(JitGatewayUtil.CommonConstant.MSG_MESSAGE_DESC);
                        logger.info("网关认证业务处理失败！\t" + errDesc + "\n");
                    }
                }
            }

            if (isSuccess) {
                logger.info("解析报文头成功！\n");
                // 解析报文体
                // 解析认证结果集
                Element authResultElement = bodyElement.element(AuthConstant.MSG_AUTH_RESULT_SET)
                        .element(AuthConstant.MSG_AUTH_RESULT);

                isSuccess = Boolean.valueOf(authResultElement.attributeValue(AuthConstant.MSG_SUCCESS));
                if (!isSuccess) {
                    errCode = authResultElement.elementTextTrim(AuthConstant.MSG_AUTH_MESSSAGE_CODE);
                    errDesc = authResultElement.elementTextTrim(AuthConstant.MSG_AUTH_MESSSAGE_DESC);
                    logger.info("身份认证失败，失败原因：" + errDesc);
                }
            }

            if (isSuccess) {
                logger.info("身份认证成功！\n");
                String accessControlResult = bodyElement.elementTextTrim("accessControlResult");
                logger.info("网关根据规则对该用户计算的访问控制结果:" + accessControlResult);

                // 设置返回认证结果信息
                authResult.setAccessControlResult(accessControlResult);
                if ("Deny".equals(accessControlResult)) {
                    isSuccess = false;
                    errCode = "-1";
                    errDesc = "该用户无权限访问此应用";
                } else {
                    // 解析用户属性列表
                    Element attrsElement = bodyElement.element(AuthConstant.MSG_ATTRIBUTES);
                    if (attrsElement != null) {
                        // List<Element> namespacesElements =
                        // (List<Element>)attrsElement
                        List namespacesElements = (List) attrsElement.elements(AuthConstant.MSG_ATTRIBUTE);
                        if (namespacesElements != null && namespacesElements.size() > 0) {
                            logger.info("属性个数：" + namespacesElements.size());
                            for (int i = 0; i < namespacesElements.size(); i++) {
                                // String arrs =
                                // namespacesElements.get(i).attributeValue(AuthConstant.MSG_NAMESPACE);
                                String arrs = ((Element) namespacesElements.get(i))
                                        .attributeValue(AuthConstant.MSG_NAMESPACE);
                                logger.info(arrs);
                            }
                            /*
                             * Map<String[],String> certAttributeNodeMap = new
                             * HashMap<String[],String>(); Map<String[],String>
                             * childAttributeNodeMap = new
                             * HashMap<String[],String>(); Map<String[],String>
                             * umsAttributeNodeMap = new
                             * HashMap<String[],String>(); Map<String[],String>
                             * pmsAttributeNodeMap = new
                             * HashMap<String[],String>();
                             */
                            Map certAttributeNodeMap = new HashMap();
                            Map childAttributeNodeMap = new HashMap();
                            Map umsAttributeNodeMap = new HashMap();
                            Map pmsAttributeNodeMap = new HashMap();
                            Map customAttributeNodeMap = new HashMap();
                            String[] keys = new String[2];
                            if (attrsElement != null) {
                                List attributeNodeList = attrsElement.elements(AuthConstant.MSG_ATTRIBUTE);
                                for (int i = 0; i < attributeNodeList.size(); i++) {
                                    keys = new String[2];
                                    Element userAttrNode = (Element) attributeNodeList.get(i);
                                    String msgParentName = userAttrNode.attributeValue(AuthConstant.MSG_PARENT_NAME);
                                    String name = userAttrNode.attributeValue(AuthConstant.MSG_NAME);
                                    String value = userAttrNode.getTextTrim();
                                    keys[0] = name;
                                    childAttributeNodeMap.clear();
                                    // String arrs =
                                    // namespacesElements.get(i).attributeValue(AuthConstant.MSG_NAMESPACE);
                                    String arrs = ((Element) namespacesElements.get(i))
                                            .attributeValue(AuthConstant.MSG_NAMESPACE);
                                    if (arrs.trim().equals(AuthConstant.KEY_NAMESPACE_CINAS)) {
                                        // 证书信息
                                        if (msgParentName != null && !msgParentName.equals("")) {
                                            keys[1] = msgParentName;
                                            if (value != null && value.length() > 0)
                                                childAttributeNodeMap.put(keys, value);
                                        } else {
                                            if (value != null && value.length() > 0){
                                                certAttributeNodeMap.put(keys, value);
                                                if(name.endsWith(CaConfig.subjectDN)){
                                                    authResult.setSubjectDN(value);
                                                }
                                            }
                                        }
                                        certAttributeNodeMap.putAll(childAttributeNodeMap);
                                    } else if (arrs.trim().equals(AuthConstant.KEY_NAMESPACE_UMS)) {
                                        // UMS信息
                                        if (msgParentName != null && !msgParentName.equals("")) {
                                            keys[1] = msgParentName;
                                            if (value != null && value.length() > 0) {
                                                childAttributeNodeMap.put(keys, value);
                                            }
                                        } else {
                                            if (value != null && value.length() > 0){
                                                umsAttributeNodeMap.put(keys, value);
                                            }
                                        }
                                        umsAttributeNodeMap.putAll(childAttributeNodeMap);
                                        // } else if
                                        // (arrs.trim().contains(AuthConstant.KEY_NAMESPACE_PMS))
                                        // {
                                    } else if (arrs.trim().indexOf(AuthConstant.KEY_NAMESPACE_PMS) != -1) {
                                        // PMS信息
                                        if (msgParentName != null && !msgParentName.equals("")) {
                                            keys[1] = msgParentName;
                                            if (value != null && value.length() > 0)
                                                childAttributeNodeMap.put(keys, value);
                                        } else {
                                            if (value != null && value.length() > 0)
                                                pmsAttributeNodeMap.put(keys, value);
                                        }
                                        pmsAttributeNodeMap.putAll(childAttributeNodeMap);
                                    } else if (arrs.trim().indexOf(AuthConstant.KEY_NAMESPACE_CUSTOM) != -1) {
                                        // 自定义信息
                                        if (msgParentName != null && !msgParentName.equals("")) {
                                            keys[1] = msgParentName;
                                            if (value != null && value.length() > 0)
                                                childAttributeNodeMap.put(keys, value);
                                        } else {
                                            if (value != null && value.length() > 0)
                                                customAttributeNodeMap.put(keys, value);
                                        }
                                        customAttributeNodeMap.putAll(childAttributeNodeMap);
                                    } else {
                                        // 如果有其他的属性信息添加到证书信息里面
                                        if (msgParentName != null && !msgParentName.equals("")) {
                                            keys[1] = msgParentName;
                                            if (value != null && value.length() > 0)
                                                childAttributeNodeMap.put(keys, value);
                                        } else {
                                            if (value != null && value.length() > 0)
                                                certAttributeNodeMap.put(keys, value);
                                        }
                                        certAttributeNodeMap.putAll(childAttributeNodeMap);
                                    }
                                }
                                // 设置返回认证结果信息
                                authResult.setCertAttributeNodeMap(certAttributeNodeMap);
                                authResult.setUmsAttributeNodeMap(umsAttributeNodeMap);
                                authResult.setPmsAttributeNodeMap(pmsAttributeNodeMap);
                                authResult.setCustomAttributeNodeMap(customAttributeNodeMap);
                            }
                        }
                    }
                }
            }
        } catch (Exception e) {
            isSuccess = false;
            e.printStackTrace();
            errDesc = e.getMessage();
        }
        logger.info("解析网关返回的认证响应报文结束");

        // 设置返回认证结果信息
        authResult.setSuccess(isSuccess);
        authResult.setErrCode(errCode);
        authResult.setErrDesc(errDesc);
        return authResult;
    }
}
