package com.yonyou.uap.tenant.utils;

import java.net.ConnectException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.authentication.ModifyPWFailedException;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springside.modules.mapper.JsonMapper;

import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.yonyou.iuap.security.esapi.IUAPESAPI;
import com.yonyou.uap.tenant.web.filter.PerformanceLoggerCollector;

import uap.web.cache.CacheManager;
import uap.web.core.ContextHolder;
import uap.web.utils.HttpTookit;
import uap.web.utils.RSAUtils;
import uap.web.utils.sign.SignEntity;
import uap.web.utils.sign.SignMake;

public class UserValidate {
	private static final Logger logger = LoggerFactory.getLogger(UserValidate.class);
	private static final Gson gson = new Gson();
	private static final String USERPWD_LOGIN_TYPE = "0"; //用户名密码登录

	public static String validate(UsernamePasswordCredential credential, JdbcTemplate jdbcTemplate) throws PreventedException {
		PerformanceLoggerCollector.start("UserValidate");
		if(USERPWD_LOGIN_TYPE.equals(credential.getIs_security_ca())){
			randomValidate(credential);
		}

		String verify_code = credential.getVerify_code();
		String username = credential.getUsername();
		String password = credential.getPassword();
		
		Map<String, String> params = new HashMap<String, String>();
		String url = getValidateURL(verify_code, jdbcTemplate);
		if(USERPWD_LOGIN_TYPE.equals(credential.getIs_security_ca())){
			if (password.contains("_encrypted")) {
				password = RSAUtils.decryptStringByJs(password.replace("_encrypted", ""));
			}
		}
		params.put("userName", username);
		params.put("userPassword", password);
		params.put("systemId", credential.getSysid());

		//SignEntity signEntity = SignMake.signEntity(url, params, "POST");
		//Map<String, String> headers = new LinkedHashMap<String, String>();
	//	headers.put("sign", signEntity.getSign());
		String result = "";
		try {
			LoginRestUtil loginRestUtil = (LoginRestUtil) ContextHolder.getContext().getBean("loginRestUtil");
			JsonResponse jsonResponse = loginRestUtil.userValidateService(username, password, credential.getSysid());
			result = gson.toJson(jsonResponse);
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println(MDC.get("callid") + e);
			logger.error(MDC.get("callid") + ":userName-" + username);
			logger.error(MDC.get("callid") + ":userPassword-" + password);
			logger.error(MDC.get("callid") + ":systemId-" + credential.getSysid());
			//logger.error(MDC.get("callid") + ":sign-" + signEntity.getSign());

			RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", "系统连接异常");
			throw new PreventedException("系统连接异常", e);
		} 
		logger.info("返回信息： " + result);
		PerformanceLoggerCollector.stop("UserValidate");
		return result;
	}

	private static void randomValidate(UsernamePasswordCredential credential) throws PreventedException {
		String randomvalue = credential.getRandomvalue();

		CacheManager cacheManager = (CacheManager) ContextHolder.getContext().getBean("cacheManager");
		if (!cacheManager.exists("tmp_sso_random_" + randomvalue).booleanValue()) {
			RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", "系统连接有效性过期，重新登录");
			throw new PreventedException("", new Exception());
		}
	}

	public static String modifyPW(UsernamePasswordCredential credential)
			throws GeneralSecurityException, PreventedException {
		randomValidate(credential);

		validatePhoneCode(credential);

		String username = credential.getUsername();
		String password = credential.getPassword();
		String newpassword = credential.getNewpass();
		String systemId = credential.getSysid();

		password = password.replace("_encrypted", "");
		password = RSAUtils.decryptStringByJs(password);
		password = new TenantPasswordEncoder("SHA1-SALT").encode(credential.getSalt(), password, username);

		newpassword = newpassword.replace("_encrypted", "");
		newpassword = RSAUtils.decryptStringByJs(newpassword);

		PublicKey publicKey = getPublicKey();
		password = RSAUtils.encryptString(publicKey, password);
		newpassword = RSAUtils.encryptString(publicKey, newpassword);

		Map<String, String> params = new HashMap<String, String>();
		params.put("userName", username);
		params.put("userPassword", password);
		params.put("newPassword", newpassword);
		params.put("systemId", systemId);

		String url = "";
		url = CasPropertyUtil.getPropertyByKey("modifyPW.rest.url");
		if (StringUtils.isBlank(url)) {
			throw new ModifyPWFailedException(username + " need modify password.");
		}

		SignEntity signEntity = SignMake.signEntity(url, params, "POST");
		Map<String, String> headers = new LinkedHashMap<String, String>();
		headers.put("sign", signEntity.getSign());
		try {
			return HttpTookit.doPost(signEntity.getSignURL(), params, headers);
		} catch (ConnectException e) {
			RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", "系统连接异常");
			throw new PreventedException("系统连接异常", e);
		}
	}

	public static void validatePhoneCode(UsernamePasswordCredential credential) throws ModifyPWFailedException, PreventedException {
		String username = credential.getUsername();
		String phoneNum = credential.getPhoneNum();
		String phoneCode = credential.getPhoneCode();

		if (StringUtils.isBlank(phoneCode)) {
			RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", "验证码为空");
		}
		String validateMsgUrl = CasPropertyUtil.getPropertyByKey("validatePhoneCode.url");
    	validateMsgUrl = validateMsgUrl+"?phone="+phoneNum+"&validate="+phoneCode;
    	JSONObject param=new JSONObject();
		param.put("phone", phoneNum);
		param.put("validate", phoneCode);
    	String httpResult = HttpRequest.sendPost2(validateMsgUrl, param.toString());
    	JSONObject obj=JSONObject.parseObject(httpResult);
    	String status=obj.getString("status");
		String msg=obj.getString("msg");
		if ("0".equals(status)) {
			RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", msg);
			RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_fail", true);

			throw new ModifyPWFailedException(username + " need modify password.");
		}
	}

	private static String getValidateURL(String verify_code, JdbcTemplate jdbcTemplate) throws PreventedException {
		String key = "osp_sso_validate_url";

		CacheManager cacheManager = (CacheManager) ContextHolder.getContext().getBean("cacheManager");
		String validateurl = (String) cacheManager.get(key);
		if (StringUtils.isNoneBlank(new CharSequence[] { validateurl })) {
			return validateurl;
		}

		String sql = " select verify_url from pub_verify WHERE verify_code =? ";
		String url = null;
		try {
			verify_code = IUAPESAPI.encoder().sqlEncode(verify_code, CasPropertyUtil.getDataBaseCodec());
			url = (String) jdbcTemplate.queryForObject(sql, String.class, new Object[] { verify_code });
			cacheManager.setex(key, url, 1800);
			return url;
		} catch (Exception e) {
			RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", "未找到系统代码" + verify_code);
			throw new PreventedException("", e);
		}
	}

	public static PublicKey getPublicKey() throws PreventedException {
		String publickey = "temp_sso_publicKey";
		CacheManager cacheManager = (CacheManager) ContextHolder.getContext().getBean("cacheManager");
		RSAPublicKey pubKey = (RSAPublicKey) cacheManager.get(publickey);
		if (pubKey == null) {
			pubKey = getKeyFromRemote();
			cacheManager.setex(publickey, pubKey, 1800);
		}
		return pubKey;
	}

	private static RSAPublicKey getKeyFromRemote() throws PreventedException {
		String url = "";
		url = CasPropertyUtil.getPropertyByKey("pubkey.rest.url");
		SignEntity signEntity = SignMake.signEntity(url, null, "GET");
		Map<String,String> headers = new LinkedHashMap<String,String>();
		headers.put("sign", signEntity.getSign());
		try {
			String result = HttpTookit.doGet(signEntity.getSignURL(), null, headers);
			JsonMapper objectMapper = new JsonMapper();
			@SuppressWarnings("rawtypes")
			Map map = (Map) objectMapper.fromJson(result, Map.class);

			String publicKeyExponent = map.get("exponent").toString();
			String publicKeyModulus = map.get("modulus").toString();

			return RSAUtils.generateRSAPublicKey(publicKeyModulus, publicKeyExponent);
		} catch (ConnectException e) {
			RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", "系统连接异常");
			throw new PreventedException("系统连接异常", e);
		}
	}
}