package com.yonyou.uap.tenant.utils.des;

import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class DESEncryptPropertyConfigurer extends PropertyPlaceholderConfigurer {
	private Set<String> encryptKeySet;

	public DESEncryptPropertyConfigurer() {
		this.encryptKeySet = new HashSet<String>();
	}

	public Set<String> getEncryptKeySet() {
		return this.encryptKeySet;
	}

	public void setEncryptKeySet(Set<String> encryptKeySet) {
		this.encryptKeySet = encryptKeySet;
	}

	protected String convertProperty(String propertyName, String propertyValue) {
		if (isEncryptPropertyVal(propertyName)) {
			return DESUtils.decrypt(propertyValue);
		}
		return propertyValue;
	}

	private boolean isEncryptPropertyVal(String propertyName) {
		if (this.encryptKeySet.contains(propertyName)) {
			return true;
		}
		return false;
	}
}