package com.yonyou.uap.tenant.web.filter;

import java.io.IOException;
import java.util.UUID;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class RequestLogsFilter implements Filter {
	private static final Logger logger = LoggerFactory.getLogger(RequestLogsFilter.class);
	public static final String CALL_ID = "callid";

	public void init(FilterConfig filterConfig) throws ServletException {
	}

	public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain)
			throws IOException, ServletException {
		if ((request instanceof HttpServletRequest)) {
			HttpServletRequest httpReq = (HttpServletRequest) request;
			boolean withPerformLog = StringUtils.isNotBlank(httpReq.getHeader("withlog"));
			try {
				String callerId = httpReq.getHeader("callid");
				if (StringUtils.isBlank(callerId)) {
					callerId = UUID.randomUUID().toString();
				}
				MDC.put("callid", callerId);

				if (withPerformLog) {
					String url = httpReq.getRequestURI();
					PerformanceLoggerCollector.init();
					PerformanceLoggerCollector.start("request", url);
				}

				filterChain.doFilter(request, response);
				return;
			} finally {
				if (withPerformLog) {
					PerformanceLoggerCollector.stop("request");
					System.out.println(PerformanceLoggerCollector.getLogMessage());
					PerformanceLoggerCollector.reset();
				}
				MDC.clear();
			}
		}
		filterChain.doFilter(request, response);
	}

	public void destroy() {
	}
}