package com.yonyouccs.cinas;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;

import com.yonyouccs.config.CaConfig;
import com.yonyouccs.gateway.util.JitGatewayUtil;
import com.yonyouccs.gateway.util.JitGatewayUtil.CommonConstant;

import uap.web.cache.CacheManager;
import uap.web.core.ContextHolder;
/**
 * 生成认证原文servlet demo
 * @author weichang_ding
 *
 */
public class RandomServlet extends HttpServlet {
    private static final long serialVersionUID = 7686671397537106958L;
    private static final Log logger = LogFactory.getLog(RandomServlet.class);
    CaConfig caConfig = new CaConfig();
	
//	// 配置文件地址
//	private String propertiesURL = null;
//	
//	// 配置文件正确标记
//	private boolean configItemRightFlag = true;

	public void init(ServletConfig cfg) throws ServletException {
		logger.info("生成原文初始化开始");
		
//		// 读取参数-配置文件URL
//		propertiesURL = cfg.getInitParameter("propertiesURL");
		
//		// 调用工具类方法初始化配置
//		configItemRightFlag = JitGatewayUtil.initConfigBean(propertiesURL);
		
//		logger.info("生成原文初始化结束");
	}

	protected void doGet(HttpServletRequest req, HttpServletResponse resp)
			throws IOException, ServletException {
//		// 配置文件不正确则返回
//		if(!configItemRightFlag){
//			logger.info("配置文件不正确");
//			return;
//		}
		
		// 实例化网关工具类
		JitGatewayUtil jitGatewayUtil = new JitGatewayUtil();
		HttpServletRequest request = (HttpServletRequest) req;
		HttpServletResponse response = (HttpServletResponse) resp;
		//是否开启二维码
//		Object qrCodeAuthObj = JitGatewayUtil.configMap.
//				get(JitGatewayUtil.ConfigConstant.KEY_QRCODE_AUTH);
//		String qrCodeAuthStr = String.valueOf(qrCodeAuthObj);
		String randNum = null;
//		if("false".equals(qrCodeAuthStr)){
		if( ! CaConfig.QRCodeAuth){
			logger.info("生成原文开始");

			// 设置页面不缓存
			response.setHeader("Pragma", "No-cache");
			response.setHeader("Cache-Control", "no-cache");
			response.setDateHeader("Expires", 0);

			// 调用网关工具方法请求认证原文
//			randNum = jitGatewayUtil.generateRandomNum();
			randNum = generateRandomNum();
			// 如果请求的认证原文为空，设置错误状态并返回
			if (!JitGatewayUtil.isNotNull(randNum)) {
				logger.info("生成原文为空！");
				response.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
				return;
			}

			CacheManager cacheManager = (CacheManager) ContextHolder.getContext().getBean("cacheManager");
			// 设置认证原文到redis，用于程序向后传递，通讯报文中使用
			cacheManager.setex("original_data", randNum, 600);

			logger.info("生成原文结束，成功生成原文：" + randNum);
		}

		// 同步回调
		response.setContentType("application/x-json");//需要设置ContentType 为"application/x-json"
		PrintWriter out = response.getWriter();
		out.write("{\"original_data\":\""+randNum+"\",\"QRCodeAuth\":\""+CaConfig.QRCodeAuth+"\",\"original\":\""+randNum+"\"}");
		out.flush();
		out.close();
	}

	protected void doPost(HttpServletRequest req, HttpServletResponse resp)
			throws IOException, ServletException {
		doGet(req, resp);
	}
	
	   /**
     * 生成认证原文(根据randomFrom配置生成原文)
     * 
     * @return 认证原文
     */
	private String generateRandomNum() {
        // randomFrom 1：调用应用服务器 2：调用网关
        String random = "";
//      if("2".equals(configMap.get(ConfigConstant.KEY_RANDOM_FROM))){
        if("2".equals(CaConfig.randomFrom)){
            logger.info("调用网关生成原文");
            random = generateRandomNumFromGagewayServer();
        }else
        {
            logger.info("调用应用服务器生成原文");
            random = generateRandomNumByApplication();
        }
        
        logger.info("生成原文结束，原文：" + random);
        return random;
    }
    
    /**
     * 应用服务器产生认证原文(第二步 服务端产生认证原文)
     * 
     * @return 认证原文
     */
    private String generateRandomNumByApplication() {
        String num = "1234567890abcdefghijklmnopqrstopqrstuvwxyz";
        int size = 6;
        char[] charArray = num.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size; i++) {
            sb.append(charArray[((int) (Math.random() * 10000) % charArray.length)]);
        }
        return sb.toString();
    }
    /**
     * 连接网关服务器产生认证原文
     * 
     * @return 认证原文
     * @throws DocumentException
     */
    private String generateRandomNumFromGagewayServer(){
        String errCode = null;
        String errDesc = null;
        byte[] messagexml = null;
        
        // 组装认证原文请求报文数据
        logger.info("组装认证原文请求报文数据开始");
        Document reqDocument = DocumentHelper.createDocument();
        Element root = reqDocument.addElement(CommonConstant.MSG_ROOT);
        Element requestHeadElement = root.addElement(CommonConstant.MSG_HEAD);
        Element requestBodyElement = root.addElement(CommonConstant.MSG_BODY);
        
        // 组装报文头信息 
        requestHeadElement.addElement(CommonConstant.MSG_VSERSION).setText(CommonConstant.MSG_VSERSION_VALUE_10);
        requestHeadElement.addElement(CommonConstant.MSG_SERVICE_TYPE).setText(
                JitGatewayUtil.RandomConstant.MSG_SERVICE_TYPE_VALUE);

        // 组装报文体信息
        // 组装应用标识信息
        requestBodyElement.addElement(CommonConstant.MSG_APPID).
        //setText(configMap.get(ConfigConstant.KEY_APP_ID));
        // jdk1.4
//      setText(configMap.get(ConfigConstant.KEY_APP_ID).toString());
        setText(CaConfig.appId);
        StringBuffer reqMessageData = new StringBuffer();
        try {
            // 将认证原文请求报文写入输出流 开始
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            XMLWriter writer = new XMLWriter(outStream);
            writer.write(reqDocument);
            messagexml = outStream.toByteArray();
            // 将认证原文请求报文写入输出流完毕

            reqMessageData.append("请求内容开始！\n");
            reqMessageData.append(outStream.toString() + "\n");
            reqMessageData.append("请求内容结束！\n");
            logger.info(reqMessageData.toString() + "\n");
        } catch (Exception e) {
            errDesc = "组装原文请求报文时出现异常";
            logger.info("组装原文请求报文时出现异常" + e.getMessage());
        }
        
        // 组装认证原文请求报文数据完毕
        logger.info("组装认证原文请求报文数据结束");

        // 创建与网关的HTTP连接，发送认证原文请求报文，并接收认证原文响应报文
        // 创建与网关的HTTP连接开始
        logger.info("创建与网关的HTTP连接，发送认证原文请求报文开始");
//        String authURL = jitGatewayUtilBean.getAuthURL();
        String authURL = CaConfig.authURL;
        int statusCode = 500;
        HttpClient httpClient = new HttpClient();
        PostMethod postMethod = new PostMethod(authURL);
        postMethod.setRequestHeader("Connection", "close");

        // 设置报文传送的编码格式
        postMethod.setRequestHeader("Content-Type", "text/xml;charset=UTF-8");
        // 设置发送认证请求内容开始
        postMethod.setRequestBody(new ByteArrayInputStream(messagexml));
        // 设置发送认证请求内容结束
        
        // 执行postMethod
        try {
            // 发送原文请求报文与网关通讯
            URL url = JitGatewayUtil.protocol(authURL);
            statusCode = httpClient.executeMethod(postMethod);
            if(url != null && "https".equals(url.getProtocol())){
                Protocol.unregisterProtocol("https");
            }
        } catch (Exception e) {
            errCode = String.valueOf(statusCode);
            errDesc = e.getMessage();
            logger.info("发送原文请求报文与网关连接出现异常：" + errDesc);
            postMethod.releaseConnection();
            httpClient.getHttpConnectionManager().closeIdleConnections(0);
            httpClient = null;
            String errorJdkMess = JitGatewayUtil.errorJdkMess(e);
            if(errorJdkMess != null){
                errDesc = errorJdkMess;
            }
            e.printStackTrace();
            return null;
        }
        logger.info("创建与网关的HTTP连接，发送认证原文请求报文结束");

        // 网关返回认证原文响应
        StringBuffer respMessageData = new StringBuffer();
        String respMessageXml = null;
        // 当返回200或500状态时处理业务逻辑
        if (statusCode == HttpStatus.SC_OK || 
                statusCode == HttpStatus.SC_INTERNAL_SERVER_ERROR) {
            try {
                // 接收通讯报文并处理开始
                byte[] inputstr = postMethod.getResponseBody();

                ByteArrayInputStream byteinputStream = new ByteArrayInputStream(inputstr);
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                int ch = 0;
                try {
                    while ((ch = byteinputStream.read()) != -1) {
                        int upperCh = (char) ch;
                        outStream.write(upperCh);
                    }
                } catch (Exception e) {
                    errDesc = e.getMessage();
                }

                // 200 表示返回处理成功
                if (statusCode == HttpStatus.SC_OK) {
                    respMessageData.append("响应内容开始！\n");
                    respMessageData.append(new String(outStream.toByteArray(),"UTF-8") + "\n");
                    respMessageData.append("响应内容开始！\n");
                    respMessageXml = new String(outStream.toByteArray(),"UTF-8");
                } else {
                    // 500 表示返回失败，发生异常
                    respMessageData.append("响应500内容开始！\n");
                    respMessageData.append(new String(outStream.toByteArray()) + "\n");
                    respMessageData.append("响应500内容结束！\n");
                    errCode = String.valueOf(statusCode);
                    errDesc = new String(outStream.toByteArray());
                }
                logger.info("网关返回响应内容：" + respMessageData.toString());
            } catch (IOException e) {
                errCode = String.valueOf(statusCode);
                errDesc = e.getMessage();
                logger.info("读取原文请求响应报文出现异常：" + errCode + "," + errDesc);
            } finally {
                if (httpClient != null) {
                    postMethod.releaseConnection();
                    httpClient.getHttpConnectionManager().closeIdleConnections(0);
                }
            }
        }

        // 接收并解析网关服务器返回的原文请求响应报文
        Document respDocument = null;
        Element headElement = null;
        Element bodyElement = null;
        
        logger.info("解析网关服务器返回的原文请求响应报文开始");
        try {
            respDocument = DocumentHelper.parseText(respMessageXml);
        } catch (DocumentException e) {
            logger.info("解析认证返回信息异常：" + e.getMessage());
        }

        headElement = respDocument.getRootElement().element(CommonConstant.MSG_HEAD);
        bodyElement = respDocument.getRootElement().element(CommonConstant.MSG_BODY);

        // 解析报文头开始
        if (headElement != null) {
            boolean state = Boolean.valueOf(
                headElement.elementTextTrim(CommonConstant.MSG_MESSAGE_STATE));
            if (state) {
                errCode = headElement.elementTextTrim(CommonConstant.MSG_MESSAGE_CODE);
                errDesc = headElement.elementTextTrim(CommonConstant.MSG_MESSAGE_DESC);
                logger.info("向网关请求原文失败：" + errCode + "," + errDesc);
            }
        }

        // 解析原文
        Element originalElement = bodyElement.element(CommonConstant.MSG_ORIGINAL);
        String original = "";
        if (originalElement != null) {
            original = originalElement.getStringValue();
            logger.info("向网关请求原文成功，生成原文：" + original);
        }
        logger.info("解析网关服务器返回的原文请求响应报文结束");
        
        // 返回认证原文
        return original;
    }
}
