//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.yonyouccs.monitor;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.web.context.ContextLoader;

public class PingService {
    private static final Logger logger = LoggerFactory.getLogger(PingService.class);
    public static final String PONG = "PONG";

    public PingService() {
    }

    public String get() {
        ApplicationContext applicationContext = ContextLoader.getCurrentWebApplicationContext();
        Map<String, DataSource> map = applicationContext.getBeansOfType(DataSource.class);
        if (map.size() == 0) {
            logger.warn("There-is-NO-DataSource-in-the-project !!!");
            return "PONG";
        } else {
            Iterator var3 = map.entrySet().iterator();

            DataSource ds;
            do {
                if (!var3.hasNext()) {
                    return "PONG";
                }

                Entry<String, DataSource> entry = (Entry)var3.next();
                ds = (DataSource)entry.getValue();
                logger.debug("current-ping-DataSource-->" + ds);
            } while(this.pingDB(ds));

            return "DB-ERROR-" + ds;
        }
    }

    private boolean pingDB(DataSource dataSource) {
        Connection conn = null;
        PreparedStatement pst = null;
        String sql = null;
        sql = "select now()";

        boolean var6;
        try {
            conn = dataSource.getConnection();
            pst = conn.prepareStatement(sql);
            pst.executeQuery();
            boolean var5 = true;
            return var5;
        } catch (Exception var20) {
            logger.error("SQLException->", var20);
            var6 = false;
        } finally {
            if (null != pst) {
                try {
                    pst.close();
                } catch (SQLException var19) {
                    logger.error("pst.close();", var19);
                }
            }

            if (conn != null) {
                try {
                    conn.close();
                } catch (SQLException var18) {
                    logger.error("conn.close();", var18);
                }
            }

        }

        return var6;
    }
}
