package org.jasig.cas.authentication;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class UsernamePasswordCredential implements Credential, Serializable {
	public static final String AUTHENTICATION_ATTRIBUTE_PASSWORD = "credential";
	private static final long serialVersionUID = -700605081472810939L;
	private static final String PASSWORD_SUFFIX = "+password";

	@NotNull
	@Size(min = 1, message = "required.username")
	private String username;

	@NotNull
	@Size(min = 1, message = "required.password")
	private String password;

	@NotNull
	@Size(min = 1, message = "required.sysid")
	private String sysid;

	@NotNull
	@Size(min = 1, message = "required.verify_code")
	private String verify_code;

	@Size(min = 1, message = "required.tokeninfo")
	private String tokeninfo;
	private String openid;
	private String tenantid;
	private String service;
	private HashMap<String, Object> attrparam;
	private boolean firstSuccess = false;
	private String randomvalue;
	private int isAutoLogin = 0;

	private String phoneNum;

	private String encodePhoneNum;

	@NotNull
	private String phoneCode;

	private String salt;

	@NotNull
	@Size(min = 1, message = "required.newpass")
	private String newpass;

	private String userCode;

	private String authMode;
	private String original;
	private String signed_data;

	private String is_security_ca;

	private String userphone;
	private String uservertycode;

	public String getService() {
		return this.service;
	}

	public void setService(String service) {
		this.service = service;
	}

	public UsernamePasswordCredential() {
	}

	public UsernamePasswordCredential(String userName, String password) {
		this.username = userName;
		this.password = password;
	}

	public UsernamePasswordCredential(String userName, String password, int isAutoLogin) {
		this.username = userName;
		this.password = password;
		this.isAutoLogin = isAutoLogin;
	}

	public UsernamePasswordCredential(String userName, String password, String sysid) {
		this.username = userName;
		this.password = password;
		this.sysid = sysid;
	}

	public UsernamePasswordCredential(String userName, String password, String sysid, String verify_code) {
		this.username = userName;
		this.password = password;
		this.sysid = sysid;
		this.verify_code = verify_code;
	}

	public UsernamePasswordCredential(String userName, String password, String sysid, String verify_code,
			String tokeninfo) {
		this.username = userName;
		this.password = password;
		this.sysid = sysid;
		this.verify_code = verify_code;
		this.tokeninfo = tokeninfo;
	}

	public UsernamePasswordCredential(String userName, String password, String sysid, String verify_code,
			String tokeninfo, String openid) {
		this.username = userName;
		this.password = password;
		this.sysid = sysid;
		this.verify_code = verify_code;
		this.tokeninfo = tokeninfo;
		this.openid = openid;
	}

	public UsernamePasswordCredential(String userName, String password, String sysid, String verify_code,
			String tokeninfo, String openid, String service) {
		this.username = userName;
		this.password = password;
		this.sysid = sysid;
		this.verify_code = verify_code;
		this.tokeninfo = tokeninfo;
		this.openid = openid;
		this.service = service;
	}

	public final String getPassword() {
		return this.password;
	}

	public final void setPassword(String password) {
		this.password = password;
	}

	public final String getUsername() {
		return this.username;
	}

	public final void setUsername(String userName) {
		this.username = userName;
	}

	public String getSysid() {
		return this.sysid;
	}

	public void setSysid(String sysid) {
		this.sysid = sysid;
	}

	public String getVerify_code() {
		return this.verify_code;
	}

	public void setVerify_code(String verify_code) {
		this.verify_code = verify_code;
	}

	public String getOpenid() {
		return this.openid;
	}

	public void setOpenid(String openid) {
		this.openid = openid;
	}

	public String getTokeninfo() {
		return this.tokeninfo;
	}

	public void setTokeninfo(String tokeninfo) {
		this.tokeninfo = tokeninfo;
	}

	public String getTenantid() {
		return this.tenantid;
	}

	public void setTenantid(String tenantid) {
		this.tenantid = tenantid;
	}

	public Map<String, Object> getAttrparam() {
		return this.attrparam;
	}

	public void setAttrparam(HashMap<String, Object> attrparam) {
		this.attrparam = attrparam;
	}

	public String getNewpass() {
		return this.newpass;
	}

	public void setNewpass(String newpass) {
		this.newpass = newpass;
	}

	public boolean isFirstSuccess() {
		return this.firstSuccess;
	}

	public void setFirstSuccess(boolean firstSuccess) {
		this.firstSuccess = firstSuccess;
	}

	public String getRandomvalue() {
		return this.randomvalue;
	}

	public void setRandomvalue(String randomvalue) {
		this.randomvalue = randomvalue;
	}

	public int getIsAutoLogin() {
		return this.isAutoLogin;
	}

	public void setIsAutoLogin(int isAutoLogin) {
		this.isAutoLogin = isAutoLogin;
	}

	public String getId() {
		return this.username;
	}

	public String getPhoneNum() {
		return phoneNum;
	}

	public void setPhoneNum(String phoneNum) {
		this.phoneNum = phoneNum;
	}

	public String getEncodePhoneNum() {
		if (StringUtils.isNotBlank(this.phoneNum)) {
			return this.phoneNum.replaceAll("(?<=[\\d]{3})\\d(?=[\\d]{3})", "*");
		}
		return "未设置手机号";
	}

	public String getPhoneCode() {
		return phoneCode;
	}

	public void setPhoneCode(String phoneCode) {
		this.phoneCode = phoneCode;
	}

	public String getSalt() {
		return salt;
	}

	public void setSalt(String salt) {
		this.salt = salt;
	}

	public String getUserCode() {
		return userCode;
	}

	public void setUserCode(String userCode) {
		this.userCode = userCode;
	}

	public String getAuthMode() {
		return authMode;
	}

	public void setAuthMode(String authMode) {
		this.authMode = authMode;
	}

	public String getOriginal() {
		return original;
	}

	public void setOriginal(String original) {
		this.original = original;
	}

	public String getSigned_data() {
		return signed_data;
	}

	public void setSigned_data(String signed_data) {
		this.signed_data = signed_data;
	}

	public String toString() {
		return this.username + PASSWORD_SUFFIX;
	}

	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}
		if ((o == null) || (getClass() != o.getClass())) {
			return false;
		}

		UsernamePasswordCredential that = (UsernamePasswordCredential) o;

		if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
			return false;
		}

		if (this.username != null ? !this.username.equals(that.username) : that.username != null) {
			return false;
		}

		return true;
	}

	public int hashCode() {
		return new HashCodeBuilder().append(this.username).append(this.password).toHashCode();
	}

	public String getIs_security_ca() {
		return is_security_ca;
	}

	public void setIs_security_ca(String is_security_ca) {
		this.is_security_ca = is_security_ca;
	}

	public String getUserphone() {
		return userphone;
	}

	public void setUserphone(String userphone) {
		this.userphone = userphone;
	}

	public String getUservertycode() {
		return uservertycode;
	}

	public void setUservertycode(String uservertycode) {
		this.uservertycode = uservertycode;
	}

}