package org.jasig.cas.ticket.support;

import java.util.concurrent.TimeUnit;
import org.jasig.cas.ticket.TicketState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public final class TicketGrantingTicketExpirationPolicy extends AbstractCasExpirationPolicy
  implements InitializingBean
{
  private static final long serialVersionUID = 7670537200691354820L;
  private long maxTimeToLiveInMilliSeconds;
  private long timeToKillInMilliSeconds;
  private Logger myLogger = LoggerFactory.getLogger(TicketGrantingTicketExpirationPolicy.class);

  @Deprecated
  public TicketGrantingTicketExpirationPolicy()
  {
    this.maxTimeToLiveInMilliSeconds = 0L;
    this.timeToKillInMilliSeconds = 0L;
  }

  public TicketGrantingTicketExpirationPolicy(long maxTimeToLive, long timeToKill, TimeUnit timeUnit)
  {
    this.maxTimeToLiveInMilliSeconds = timeUnit.toMillis(maxTimeToLive);
    this.timeToKillInMilliSeconds = timeUnit.toMillis(timeToKill);
  }

  @Deprecated
  public void setMaxTimeToLiveInMilliSeconds(long maxTimeToLiveInMilliSeconds)
  {
    this.maxTimeToLiveInMilliSeconds = maxTimeToLiveInMilliSeconds;
  }

  @Deprecated
  public void setTimeToKillInMilliSeconds(long timeToKillInMilliSeconds)
  {
    this.timeToKillInMilliSeconds = timeToKillInMilliSeconds;
  }

  @Deprecated
  public void setMaxTimeToLiveInSeconds(long maxTimeToLiveInSeconds)
  {
    if (this.maxTimeToLiveInMilliSeconds == 0L)
      this.maxTimeToLiveInMilliSeconds = TimeUnit.SECONDS.toMillis(maxTimeToLiveInSeconds);
  }

  @Deprecated
  public void setTimeToKillInSeconds(long timeToKillInSeconds)
  {
    if (this.timeToKillInMilliSeconds == 0L)
      this.timeToKillInMilliSeconds = TimeUnit.SECONDS.toMillis(timeToKillInSeconds);
  }

  public void afterPropertiesSet()
    throws Exception
  {
    Assert.isTrue(this.maxTimeToLiveInMilliSeconds >= this.timeToKillInMilliSeconds, "maxTimeToLiveInMilliSeconds must be greater than or equal to timeToKillInMilliSeconds.");
  }

  public boolean isExpired(TicketState ticketState)
  {
    long currentSystemTimeInMillis = System.currentTimeMillis();

    if (currentSystemTimeInMillis - ticketState.getCreationTime() >= this.maxTimeToLiveInMilliSeconds)
    {
      return true;
    }

    if (currentSystemTimeInMillis - ticketState.getLastTimeUsed() >= this.timeToKillInMilliSeconds)
    {
      return true;
    }

    return false;
  }
}