package org.jasig.cas.web.flow;

import java.security.interfaces.RSAPublicKey;

import javax.validation.constraints.NotNull;

import org.jasig.cas.util.UniqueTicketIdGenerator;
import org.jasig.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

import com.yonyou.uap.tenant.utils.CasPropertyUtil;

import uap.web.cache.CacheManager;
import uap.web.core.ContextHolder;
import uap.web.utils.PropertyUtil;
import uap.web.utils.RSAUtils;

public class GenerateLoginTicketAction {
	private static final String PREFIX = "LT";
	private final Logger logger = LoggerFactory.getLogger(getClass());

	@NotNull
	private UniqueTicketIdGenerator ticketIdGenerator;

	public final String generate(RequestContext context) {
		String loginTicket = this.ticketIdGenerator.getNewTicketId(PREFIX);
		this.logger.debug("Generated login ticket {}", loginTicket);
		WebUtils.putLoginTicket(context, loginTicket);

		initPubKeyParams(context);

		RequestContextHolder.getRequestContext();

		return "generated";
	}

	private void initPubKeyParams(RequestContext context) {
		CacheManager cacheManager = (CacheManager) ContextHolder.getContext().getBean("cacheManager");

		RSAPublicKey publicKey = RSAUtils.getDefaultPublicKey();
		String publicKeyExponent = publicKey.getPublicExponent().toString(16);
		String publicKeyModulus = publicKey.getModulus().toString(16);

		context.getFlowScope().put("exponent", publicKeyExponent);
		context.getFlowScope().put("modulus", publicKeyModulus);

		String url = getregisterURL();
		context.getFlowScope().put("registerurl", url);

		String tocRegisterUrl = getTocRegisterURL();
		context.getFlowScope().put("registeruserurl", tocRegisterUrl);

		String simpleRegisterUrl = getSimpleRegisterURL();
		context.getFlowScope().put("simpleregisterurl", simpleRegisterUrl);

		String forgeturl = getForgetURL();
		context.getFlowScope().put("forgeturl", forgeturl);
		String systemid = context.getRequestParameters().get("sysid");
		context.getFlowScope().put("systemid", systemid);

		String randomvaule = String.valueOf(System.currentTimeMillis());
		context.getFlowScope().put("randomvalue", randomvaule);
		cacheManager.setex("tmp_sso_random_" + randomvaule, randomvaule, 600);

		String sendPhoneCodeUrl = getSendPhoneCodeURL();
		context.getFlowScope().put("sendPhoneCodeUrl", sendPhoneCodeUrl);
	}

	private String getSimpleRegisterURL() {
		return CasPropertyUtil.getPropertyByKey("simpleregister.url");
	}

	private String getregisterURL() {
		return CasPropertyUtil.getPropertyByKey("register.url");
	}

	private String getTocRegisterURL() {
		return CasPropertyUtil.getPropertyByKey("tocregister.url");
	}

	private String getForgetURL() {
		return PropertyUtil.getPropertyByKey("forgetpw.url");
//		return CasPropertyUtil.getPropertyByKey("forgetpw.url");
	}

	private String getSendPhoneCodeURL() {
		return CasPropertyUtil.getPropertyByKey("sendPhoneCode.url");
	}

	public void setTicketIdGenerator(UniqueTicketIdGenerator generator) {
		this.ticketIdGenerator = generator;
	}
}