package org.jasig.cas.web.flow;

import javax.validation.constraints.NotNull;

import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.ticket.InvalidTicketException;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

@SuppressWarnings("deprecation")
public final class GenerateServiceTicketAction extends AbstractAction {

	@NotNull
	private CentralAuthenticationService centralAuthenticationService;

	protected Event doExecute(RequestContext context) {
		Service service = WebUtils.getService(context);
		String ticketGrantingTicket = WebUtils.getTicketGrantingTicketId(context);
		try {
			Credential credential = WebUtils.getCredential(context);

			ServiceTicket serviceTicketId = this.centralAuthenticationService.grantServiceTicket(ticketGrantingTicket,
					service, new Credential[] { credential });

			WebUtils.putServiceTicketInRequestScope(context, serviceTicketId);

			return success();
		} catch (AuthenticationException e) {
			this.logger.error("Could not verify credentials to grant service ticket", e);
		} catch (TicketException e) {
			if ((e instanceof InvalidTicketException)) {
				this.centralAuthenticationService.destroyTicketGrantingTicket(ticketGrantingTicket);
			}
			if (isGatewayPresent(context)) {
				return result("gateway");
			}
		}

		return error();
	}

	public void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
		this.centralAuthenticationService = centralAuthenticationService;
	}

	protected boolean isGatewayPresent(RequestContext context) {
		return StringUtils.hasText(context.getExternalContext().getRequestParameterMap().get("gateway"));
	}
}