package org.jasig.cas.web.flow;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

import javax.sql.DataSource;
import javax.validation.constraints.NotNull;

import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

import uap.web.core.ContextHolder;

@SuppressWarnings("deprecation")
public class TicketGrantingTicketCheckAction extends AbstractAction {
	public static final String NOT_EXISTS = "notExists";
	public static final String INVALID = "invalid";
	public static final String VALID = "valid";

	@NotNull
	private final CentralAuthenticationService centralAuthenticationService;

	public TicketGrantingTicketCheckAction(CentralAuthenticationService centralAuthenticationService) {
		this.centralAuthenticationService = centralAuthenticationService;
	}

	protected Event doExecute(RequestContext requestContext) throws Exception {
		String tgtId = WebUtils.getTicketGrantingTicketId(requestContext);

		if (!StringUtils.hasText(tgtId)) {
			return new Event(this, "notExists");
		}

		String eventId = "invalid";
		try {
			Ticket ticket = this.centralAuthenticationService.getTicket(tgtId, Ticket.class);
			if ((ticket != null) && (!ticket.isExpired())) {
				String sysid = requestContext.getRequestParameters().get("sysid");
				if ((sysid == null) || (sysid.equalsIgnoreCase(""))) {
					eventId = "valid";
				} else if ((ticket instanceof TicketGrantingTicketImpl)) {
					Map<String,Object> attributes = ((TicketGrantingTicketImpl) ticket).getAuthentication().getPrincipal().getAttributes();
					if (attributes != null) {
						ApplicationContext context = ContextHolder.getContext();
						JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource) context.getBean("dataSource"));

						String tenantId = (String) attributes.get("tenantId");
						String userId = (String) attributes.get("userId");
						Object usertypeObject = attributes.get("userType");
						int userType = -1;
						if ((usertypeObject != null) && (!usertypeObject.equals(""))) {
							userType = ((Integer) attributes.get("userType")).intValue();
						}

						if ((!StringUtils.isEmpty(tenantId)) && (!StringUtils.isEmpty(userId)) && (userType != -1)) {
							if (("tenant".equalsIgnoreCase(sysid)) || ("tenantuser".equalsIgnoreCase(sysid))
									|| ("tenantauth".equalsIgnoreCase(sysid))) {
								eventId = "valid";
							} else {
								eventId = dealAppAuth(jdbcTemplate, tenantId, sysid, userId, userType);
							}
						} else
							eventId = "invalid";
					}
				}
			}
		} catch (TicketException e) {
			this.logger.trace("Could not retrieve ticket id {} from registry.", e);
		}
		return new Event(this, eventId);
	}

	private boolean after(String date) throws ParseException {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Calendar cal = Calendar.getInstance();
		cal.setTime(sdf.parse(date));
		Calendar today = Calendar.getInstance();
		return cal.after(today);
	}

	private String dealAppAuth(JdbcTemplate jdbcTemplate, String tenantId, String sysid, String userId, int userType) {
		String eventId = "invalid";

		String groupSql = "select * from pub_auth_group_res where group_code=?";
		List<Map<String, Object>> grouplist = jdbcTemplate.queryForList(groupSql, new Object[] { sysid });
		if (grouplist.size() == 0) {
			eventId = dealOneAppAuth(jdbcTemplate, tenantId, sysid, userId, userType);
		} else if (grouplist.size() == 1) {
			Map<String, Object> map = (Map<String, Object>) grouplist.get(0);
			if (map != null) {
				String resCode = (String) map.get("res_code");
				eventId = dealOneAppAuth(jdbcTemplate, tenantId, resCode, userId, userType);
			}
		} else if (grouplist.size() > 1) {
			eventId = dealMutiAppAuth(grouplist, jdbcTemplate, tenantId, userId, userType);
		}
		return eventId;
	}

	private String dealOneAppAuth(JdbcTemplate jdbcTemplate, String tenantId, String sysid, String userId,
			int userType) {
		String eventId = "invalid";
		String buySql = "select * from pub_tenant_res where tenant_id=? and res_code=?";
		List<Map<String, Object>> list = jdbcTemplate.queryForList(buySql, new Object[] { tenantId, sysid });
		if (list.size() > 0) {
			Map<String, Object> map = (Map<String, Object>) list.get(0);
			if (map != null) {
				String enddate = (String) map.get("end_date");
				try {
					if (after(enddate)) {
						if (1 == userType) {
							eventId = "valid";
						} else {
							String sql = "select count(id) from pub_tenant_user_permission where tenant_id=? and user_id=? and res_code=?";
							int count = Integer.valueOf((String) jdbcTemplate.queryForObject(sql, String.class,
									new Object[] { tenantId, userId, sysid })).intValue();
							if (count > 0) {
								eventId = "valid";
							}
						}
					}
				} catch (Exception e) {
					this.logger.trace("Could not retrieve ticket id {} from registry.", e);
				}
			}
		}
		return eventId;
	}

	private String dealMutiAppAuth(List<Map<String, Object>> grouplist, JdbcTemplate jdbcTemplate, String tenantId,
			String userId, int userType) {
		StringBuffer rescodeBuf = new StringBuffer();
		for (Map<String, Object> oneMap : grouplist) {
			String resCode = (String) oneMap.get("res_code");
			if (!StringUtils.isEmpty(resCode)) {
				rescodeBuf.append("'" + resCode + "',");
			}
		}
		String eventId = "invalid";
		String buySql = "select * from pub_tenant_res where tenant_id=? and res_code in ("
				+ rescodeBuf.substring(0, rescodeBuf.length() - 1) + ")";
		List<Map<String, Object>> list = jdbcTemplate.queryForList(buySql, new Object[] { tenantId });
		if (list.size() > 0) {
			boolean isAfterData = false;
			for (Map<String, Object> map : list) {
				String enddate = (String) map.get("end_date");
				try {
					if (after(enddate)) {
						isAfterData = true;
						break;
					}
				} catch (Exception e) {
					this.logger.trace("Could not retrieve ticket id {} from registry.", e);
				}
			}

			if (isAfterData) {
				if (1 == userType) {
					eventId = "valid";
				} else {
					String sql = "select count(id) from pub_tenant_user_permission where tenant_id=? and user_id=? and res_code in ("
							+ rescodeBuf.substring(0, rescodeBuf.length() - 1) + ")";
					int count = Integer.valueOf(
							(String) jdbcTemplate.queryForObject(sql, String.class, new Object[] { tenantId, userId }))
							.intValue();
					if (count > 0) {
						eventId = "valid";
					}
				}
			}
		}
		return eventId;
	}
}