package uap.web.cache.utils;

import java.security.KeyPair;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.jasig.cas.ticket.ServiceTicketImpl;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;

public class KryoxFactory extends BasePooledObjectFactory<Kryox> {
	public Kryox create() throws Exception {
		Kryox kryo = new Kryox();
		kryo.register(KeyPair.class);
		kryo.register(TicketGrantingTicketImpl.class);
		kryo.register(ServiceTicketImpl.class);
		return kryo;
	}

	public PooledObject<Kryox> wrap(Kryox obj) {
		DefaultPooledObject<Kryox> pooledObject = null;
		if ((obj instanceof Kryox)) {
			pooledObject = new DefaultPooledObject<Kryox>(obj);
		}

		return pooledObject;
	}
}