package uap.web.cache.utils;

import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class KryoxPool {
	private GenericObjectPool<Kryox> pool;
	private static KryoxPool kryoxPool;

	public static synchronized KryoxPool getInstance() {
		if (kryoxPool == null) {
			GenericObjectPoolConfig config = new GenericObjectPoolConfig();
			config.setMaxTotal(300);
			config.setMaxWaitMillis(1000L);
			kryoxPool = new KryoxPool(config);
		}
		return kryoxPool;
	}

	private KryoxPool(GenericObjectPoolConfig config) {
		KryoxFactory factory = new KryoxFactory();
		this.pool = new GenericObjectPool<Kryox>(factory, config);
	}

	public Kryox getKryox() throws Exception {
		return (Kryox) this.pool.borrowObject();
	}

	public void returnKryox(Kryox kryox) {
		if (kryox != null)
			this.pool.returnObject(kryox);
	}
}