package uap.web.listener;

import java.security.KeyPair;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import uap.web.cache.CacheManager;
import uap.web.core.ContextHolder;
import uap.web.utils.RSAUtils;

public class CustomServletContextListener
  implements ServletContextListener
{
  protected final Logger logger = LoggerFactory.getLogger(getClass());

  public void contextDestroyed(ServletContextEvent arg0)
  {
  }

  public void contextInitialized(ServletContextEvent event) {
    WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext(event.getServletContext());
    ContextHolder.setContext(wac);
    try
    {
      CacheManager cm = (CacheManager)wac.getBean("cacheManager");

      String keypairKey = "SSO_KEY_PAIR";
      if (cm.exists(keypairKey).booleanValue()) {
        KeyPair kp = (KeyPair)cm.get(keypairKey);
        RSAUtils.setKeyPair(kp);
        this.logger.info("get keypair from redis ...");
      } else {
        KeyPair gk = RSAUtils.generateKeyPair();
        cm.set(keypairKey, gk);
        this.logger.info("generate keypair and put it into redis ...");
      }
    }
    catch (Exception e) {
      this.logger.error(e.getMessage(), e);
    }
  }
}