package uap.web.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class PropertyUtil {
	private static Properties outerprop = null;

	private static Properties innerprop = null;

	private static String outerPropertyName = "sdk.properties";

	private static String innerPropertyName = "tenant-sdk-inner.properties";

	public static void setOuterPropertyName(String outerPropertyName) {
		if (StringUtils.isNoneBlank(new CharSequence[] { outerPropertyName }))
			PropertyUtil.outerPropertyName = outerPropertyName;
	}

	private static void initOuterProperty() {
		if (outerprop == null) {
			String filePath = System.getenv("TENANT_SDK_FILEPATH");
			if (StringUtils.isBlank(filePath)) {
				filePath = System.getProperty("TENANT_SDK_FILEPATH");
			}
			if (StringUtils.isNoneBlank(new CharSequence[] { filePath })) {
				outerPropertyName = filePath;
			}

			outerprop = new Properties();
			try {
				InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(outerPropertyName);

				outerprop.load(in);
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	private static void initInnerProperty() {
		if (innerprop == null) {
			innerprop = new Properties();
			try {
				InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(innerPropertyName);

				innerprop.load(in);
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	public static String getPropertyByKey(String key) {
		initOuterProperty();
		String value = outerprop.getProperty(key);
		return StringUtils.isBlank(value) ? "" : value;
	}

	public static String getInnerPropertyByKey(String key) {
		initInnerProperty();
		String value = innerprop.getProperty(key);
		return StringUtils.isBlank(value) ? "" : value;
	}
}