package uap.web.utils.sign;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.yonyou.iuap.security.rest.common.SignProp;
import com.yonyou.iuap.security.rest.factory.ClientSignFactory;
import com.yonyou.iuap.security.rest.utils.PostParamsHelper;
import com.yonyou.iuap.security.rest.utils.SignPropGenerator;
import com.yonyou.iuap.utils.PropertyUtil;

import uap.web.utils.RestAPIUtils;

public class SignMake {
	private static Logger log = LoggerFactory.getLogger(SignMake.class);
	private static Properties properties;
	public static final String SIGNPOST = "POST";
	public static final String SIGNGET = "GET";
	public static final String SIGNDELETE = "DELETE";
	public static final String PREFIX = "tenant";

	public static String signURL(String reqURL) {
		try {
			if (reqURL.contains("?"))
				reqURL = reqURL + "&";
			else {
				reqURL = reqURL + "?";
			}
			reqURL = genator(reqURL);
			SignProp prop = SignPropGenerator.genSignProp(reqURL);
			String sign = ClientSignFactory.getSigner("tenant").sign(prop);
			reqURL = reqURL + "&sign=" + sign;
		} catch (Exception e) {
			log.error(e.getMessage(), e);
		}
		return reqURL;
	}

	public static SignEntity signEntity(String reqURL, Map<String, ?> paramsMap, String type) {
		try {
			SignEntity signEntity = new SignEntity();
			if (reqURL.contains("?"))
				reqURL = reqURL + "&";
			else {
				reqURL = reqURL + "?";
			}
			reqURL = genator(reqURL);
			SignProp prop = SignPropGenerator.genSignProp(reqURL);
			if (type.equals("POST")) {
				prop.setPostParamsStr(PostParamsHelper.genParamsStrByMap(paramsMap));
				long length = RestAPIUtils.getContentLength(paramsMap);
				prop.setContentLength(length);
			}
			String sign = ClientSignFactory.getSigner("tenant").sign(prop);

			signEntity.setSignURL(reqURL);
			signEntity.setSign(sign);
			return signEntity;
		} catch (Exception e) {
			log.error(e.getMessage(), e);
		}
		return null;
	}

	public static String genator(String requestPath) {
		String ts = System.currentTimeMillis() + "";
		try {
			loadFiles(PropertyUtil.getPropertyByKey("client.credential.path"));
		} catch (IOException e) {
			log.error(e.getMessage(), e);
		}
		requestPath = requestPath + "ts=" + ts;
		String userName = properties.getProperty("username");
		if (StringUtils.isNotBlank(userName)) {
			requestPath = requestPath + "&username=" + userName;
		}
		String appId = (String) properties.get("appId");
		if (StringUtils.isNotBlank(appId)) {
			requestPath = requestPath + "&appId=" + appId;
		} else {
			log.error("appId is empty");
			return null;
		}

		return requestPath;
	}

	private static void loadFiles(String path) throws IOException {
		if (null == properties)
			synchronized (SignMake.class) {
				if (null == properties) {
					FileInputStream in = null;
					try {
						in = new FileInputStream(path);
						properties = new Properties();
						properties.load(in);
					} finally {
						if (in != null)
							in.close();
					}
				}
			}
	}
}