/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.tenant.service.impl;

import com.yonyou.uap.tenant.entity.PasswordLevel;
import com.yonyou.uap.tenant.entity.UserExstatus;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import uap.web.core.ContextHolder;

public class PasswordPolicyUtils {
    public JdbcTemplate getJdbcTemplateDao() {
        return (JdbcTemplate)ContextHolder.getContext().getBean("jdbcTemplateDao");
    }

    public Map<String, Object> getUserStatus(String userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashSet<Integer> set = new HashSet<Integer>();
        String userExSql = " select * from pub_user_exstatus where user_id =? and exstatuscode =? ";
        List list = this.getJdbcTemplateDao().query(userExSql, (RowMapper)new /* Unavailable Anonymous Inner Class!! */, new Object[]{userId, 2});
        for (UserExstatus status : list) {
            if (status.getExstatuscode() == 2) {
                map.put("extime", status.getExtime());
            }
            set.add(status.getExstatuscode());
        }
        map.put("statusSet", set);
        return map;
    }

    public PasswordLevel getPasswordLevel(String passwordPolicy) {
        PasswordLevel pwdLevel = null;
        pwdLevel = StringUtils.isBlank((String)passwordPolicy) ? this.getPasswordLevelById("5c5865ce-cf83-4b0d-bc7d-5fae9da95701") : this.getPasswordLevelById(passwordPolicy);
        return pwdLevel;
    }

    private PasswordLevel getPasswordLevelById(String passwordPolicy) {
        String selectSql = " select * from pub_passwordlevel where pwdlevel_id =? ";
        List list = this.getJdbcTemplateDao().query(selectSql, (RowMapper)new /* Unavailable Anonymous Inner Class!! */, new Object[]{passwordPolicy});
        if (list != null && list.size() > 0) {
            return (PasswordLevel)list.get(0);
        }
        return null;
    }

    public boolean isLockByAdmin(Set<Integer> statusSet) {
        return statusSet.contains(1);
    }

    public boolean isLockBySelf(Set<Integer> statusSet) {
        return statusSet.contains(2);
    }

    public boolean getUserIsLockStatus(Date exTime, PasswordLevel pwdLevel, String userId) {
        int limitLockTime = pwdLevel.getUnlocktime();
        boolean returnValue = false;
        DateTime lastLockTime = new DateTime((Object)exTime);
        DateTime currentTime = new DateTime(System.currentTimeMillis());
        long pastTime = (currentTime.getMillis() - lastLockTime.getMillis()) / 1000L / 60L / 60L;
        if (limitLockTime != -1 && pastTime >= (long)limitLockTime) {
            this.delUserExByStatus(userId, 2);
            returnValue = true;
        }
        return returnValue;
    }

    private void delUserExByStatus(String userId, int status) {
        String deleteSql = "delete from pub_user_exstatus where user_id =? and exstatuscode =?";
        Object[] args = new Object[]{userId, status};
        this.getJdbcTemplateDao().update(deleteSql, args);
    }

    public boolean isUserInitOrResetExStatus(Set<Integer> statusSet) {
        return statusSet.contains(4) || statusSet.contains(3);
    }

    public boolean isUserPwdDisabled(String pwdstarttime, PasswordLevel pwdLevel) throws ParseException {
        boolean isUserPwdDisabled = false;
        if (StringUtils.isBlank((String)pwdstarttime)) {
            return false;
        }
        Integer validateDays = pwdLevel.getValidatedays();
        if (validateDays != null && validateDays != 0) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date startdate = formatter.parse(pwdstarttime);
            Date currDate = new Date();
            long passMillis = currDate.getTime() - startdate.getTime();
            int differDay = (int)(passMillis / 1000L / 60L / 60L / 24L);
            if (differDay > validateDays) {
                isUserPwdDisabled = true;
            }
            return isUserPwdDisabled;
        }
        return false;
    }

    public String getValidateTip(String pwdstarttime, PasswordLevel pwdLevel) throws ParseException {
        if (StringUtils.isBlank((String)pwdstarttime)) {
            return null;
        }
        if (pwdLevel == null) {
            return null;
        }
        Integer alertDays = pwdLevel.getAlertdays();
        if (alertDays != null && alertDays != 0) {
            Integer validateDays = pwdLevel.getValidatedays();
            if (validateDays != null && validateDays != 0) {
                String sTip = null;
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date startdate = formatter.parse(pwdstarttime);
                if (startdate == null) {
                    return sTip;
                }
                int instant = validateDays - alertDays;
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(startdate);
                cal.add(6, instant);
                Date tipDate = cal.getTime();
                Date currDate = new Date();
                long passMillis = currDate.getTime() - tipDate.getTime();
                int passdays = (int)(passMillis / 1000L / 60L / 60L / 24L);
                if (passdays >= 0 && passdays < alertDays) {
                    sTip = "\u5bc6\u7801\u8fd8\u6709" + Integer.toString(alertDays - passdays) + "\u5929\u5931\u6548";
                }
                return sTip;
            }
            return null;
        }
        return null;
    }

    public boolean isLock(PasswordLevel pwdLevel) {
        return pwdLevel.getUnlocktime() != 0;
    }

    public boolean isExceedErrorPasswordCount(PasswordLevel pwdLevel, int count) {
        return count > pwdLevel.getErrorloginthreshold();
    }

    public void lockUser(String userId) {
        String deleteSql = "delete from pub_user_exstatus where user_id =? and exstatuscode =2";
        Object[] args = new Object[]{userId};
        this.getJdbcTemplateDao().update(deleteSql, args);
        UserExstatus exstatus = new UserExstatus();
        exstatus.setExstatuscode(2);
        exstatus.setUserId(userId);
        exstatus.setExtime(new Date());
        this.addUserExstatus(exstatus);
    }

    private void addUserExstatus(UserExstatus userExstatus) {
        if (userExstatus.getUserexId() == null || "".equalsIgnoreCase(userExstatus.getUserexId())) {
            userExstatus.setUserexId(UUID.randomUUID().toString());
        }
        String insertSql = "insert into pub_user_exstatus(userex_id,tenant_id,user_id,exstatuscode,extime) values(?,?,?,?,?) ";
        Object[] args = new Object[]{userExstatus.getUserexId(), "", userExstatus.getUserId(), userExstatus.getExstatuscode(), userExstatus.getExtime()};
        this.getJdbcTemplateDao().update(insertSql, args);
    }
}

