/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.tenant.servlet;

import com.yonyou.uap.tenant.validateImage.ValidateCode;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uap.web.cache.CacheManager;
import uap.web.core.ContextHolder;

public class ValidateImageServlet
extends HttpServlet {
    private static final long serialVersionUID = -4634200773198662771L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected void doGet(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        this.generatePic(req, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.doPost(request, response);
        this.generatePic(request, response);
    }

    private void generatePic(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        CacheManager cacheManager = (CacheManager)ContextHolder.getContext().getBean("cacheManager");
        response.setContentType("image/jpeg");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        String key = request.getParameter("ts");
        ValidateCode vCode = null;
        try {
            vCode = new ValidateCode(120, 40, 4, 40);
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return;
        }
        cacheManager.setex(key + vCode.getCode().toLowerCase(), (Serializable)((Object)vCode.getCode().toLowerCase()), 60);
        vCode.write((OutputStream)response.getOutputStream());
    }

    public void init() throws ServletException {
        super.init();
    }
}

