/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.tenant.utils;

import com.yonyou.uap.tenant.entity.PasswordLevel;
import com.yonyou.uap.tenant.entity.Tenant;
import com.yonyou.uap.tenant.entity.TenantRes;
import com.yonyou.uap.tenant.entity.TenantUser;
import com.yonyou.uap.tenant.service.impl.PasswordPolicyUtils;
import com.yonyou.uap.tenant.service.impl.ResGroupService;
import com.yonyou.uap.tenant.service.impl.ResTenantService;
import com.yonyou.uap.tenant.service.impl.TenantResService;
import com.yonyou.uap.tenant.service.impl.TenantService;
import com.yonyou.uap.tenant.service.impl.TenantUserService;
import com.yonyou.uap.tenant.service.impl.UserPermissionService;
import com.yonyou.uap.tenant.utils.DateUtils;
import com.yonyou.uap.tenant.utils.JsonResponse;
import com.yonyou.uap.tenant.utils.PasswordUtils;
import com.yonyou.uap.tenant.utils.UserValidate;
import com.yonyou.uap.tenant.web.filter.PerformanceLoggerCollector;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springside.modules.security.utils.Digests;
import org.springside.modules.utils.Encodes;
import uap.web.cache.CacheManager;
import uap.web.core.ContextHolder;
import uap.web.utils.PropertyUtil;

public class LoginRestUtil {
    private static final Logger logger = LoggerFactory.getLogger(UserValidate.class);

    public TenantUserService getTenantUserService() {
        return (TenantUserService)ContextHolder.getContext().getBean("userService");
    }

    public TenantService getTenantService() {
        return (TenantService)ContextHolder.getContext().getBean("tenantService");
    }

    public PasswordPolicyUtils getPasswordPolicyUtils() {
        return (PasswordPolicyUtils)ContextHolder.getContext().getBean("passwordUtil");
    }

    public JdbcTemplate getJdbcTemplate() {
        return (JdbcTemplate)ContextHolder.getContext().getBean("jdbcTemplateDao");
    }

    public CacheManager getCacheManager() {
        return (CacheManager)ContextHolder.getContext().getBean("cacheManager");
    }

    public ResGroupService getResGroupService() {
        return (ResGroupService)ContextHolder.getContext().getBean("resGroupService");
    }

    public ResTenantService getResTenantService() {
        return (ResTenantService)ContextHolder.getContext().getBean("resTenantService");
    }

    public TenantResService getTenantResService() {
        return (TenantResService)ContextHolder.getContext().getBean("tenantResService");
    }

    public UserPermissionService getUserPermissionService() {
        return (UserPermissionService)ContextHolder.getContext().getBean("userPermissionService");
    }

    public JsonResponse userValidateService(String userName, String password, String systemId) {
        PerformanceLoggerCollector.start((String)"validateUser");
        JsonResponse json = new JsonResponse();
        if (StringUtils.isBlank((String)userName) || StringUtils.isBlank((String)password)) {
            json.failed("\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e3a\u7a7a");
            return json;
        }
        TenantUser user = null;
        PerformanceLoggerCollector.start((String)"queryuser");
        List userList = this.getTenantUserService().findByLoginName(userName);
        if (userList.size() == 0) {
            logger.error("\u6570\u636e\u6709\u9519\u8bef\uff1a\u6839\u636e\u7528\u6237\u540d\u67e5\u627e\u7528\u6237\u672a\u5339\u914d\u5230\u7528\u6237\uff0c\u7528\u6237\u540d\uff1a" + userName);
            json.failed("\u8be5\u7528\u6237\u540d\u672a\u5339\u914d\u5230\u7528\u6237");
            return json;
        }
        if (userList.size() > 1) {
            logger.error("\u6570\u636e\u6709\u9519\u8bef\uff1a\u6839\u636e\u7528\u6237\u540d\u67e5\u627e\u7528\u6237\u5339\u914d\u5230\u591a\u4e2a\u7528\u6237\uff0c\u7528\u6237\u540d\uff1a" + userName);
            json.failed("\u8be5\u7528\u6237\u540d\u5339\u914d\u5230\u591a\u4e2a\u7528\u6237");
            return json;
        }
        user = (TenantUser)userList.get(0);
        String checkPwd = null;
        if (user != null) {
            checkPwd = !user.getUserPassword().equals(password) ? PasswordUtils.encodePasswordByUserCode((String)password, (String)user.getSalt(), (String)user.getUserCode()) : password;
            if (user.getUserStates() == 0) {
                json.failed("\u7528\u6237\u5df2\u88ab\u505c\u7528");
                return json;
            }
            PerformanceLoggerCollector.stop((String)"queryuser");
            PerformanceLoggerCollector.start((String)"querytenant");
            Tenant tenant = this.getTenantService().getPubTenantById(user.getTenantId());
            if (tenant == null) {
                json.setStatus(4);
                json.setMessage("\u8bf7\u5148\u6ce8\u518c\u79df\u6237\u4fe1\u606f\u518d\u767b\u5f55");
                json.put((Object)"userTel", (Object)user.getUserMobile());
                return json;
            }
            String errorMsg = this.validateTenant(tenant, user, null);
            if (StringUtils.isNotBlank((String)errorMsg)) {
                return json.failedWithReturn(errorMsg);
            }
            PerformanceLoggerCollector.stop((String)"querytenant");
            PerformanceLoggerCollector.start((String)"queryPasswordPolicy");
            Map map = this.getPasswordPolicyUtils().getUserStatus(user.getUserId());
            Set statusSet = (Set)map.get("statusSet");
            Date exTime = (Date)map.get("extime");
            PasswordLevel pwdLevel = this.getPasswordPolicyUtils().getPasswordLevel(tenant.getPasswordPolicy());
            if (this.getPasswordPolicyUtils().isLockByAdmin(statusSet)) {
                json.failed("\u8d26\u6237\u88ab\u7ba1\u7406\u5458\u9501\u5b9a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u89e3\u9501");
                return json;
            }
            if (this.getPasswordPolicyUtils().isLockBySelf(statusSet) && !this.getPasswordPolicyUtils().getUserIsLockStatus(exTime, pwdLevel, user.getUserId())) {
                json.failed("\u8d26\u6237\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                return json;
            }
            if (checkPwd.equals(user.getUserPassword())) {
                String sha1DefaultPwd;
                String defaultPwd;
                if (this.getPasswordPolicyUtils().isUserInitOrResetExStatus(statusSet) && this.mustModifyDefaultPwd(user.getTenantId())) {
                    json.setStatus(2);
                    json.setMessage("\u8bf7\u4fee\u6539\u5bc6\u7801");
                    json.put((Object)"tenant", (Object)tenant.getTenantName());
                    json.put((Object)"usertype", (Object)user.getTypeId());
                    json.put((Object)"user", (Object)user);
                    return json;
                }
                boolean flag = false;
                try {
                    flag = this.getPasswordPolicyUtils().isUserPwdDisabled(user.getPwdstarttime(), pwdLevel);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    json.failed("\u67e5\u8be2\u51fa\u9519");
                    return json;
                }
                if (flag) {
                    json.setStatus(2);
                    json.setMessage("\u5bc6\u7801\u5df2\u7ecf\u8d85\u8fc7\u6709\u6548\u671f\uff0c\u8bf7\u4fee\u6539\u5bc6\u7801");
                    json.put((Object)"tenant", (Object)tenant.getTenantName());
                    json.put((Object)"usertype", (Object)user.getTypeId());
                    json.put((Object)"user", (Object)user);
                    return json;
                }
                String tip = null;
                try {
                    tip = this.getPasswordPolicyUtils().getValidateTip(user.getPwdstarttime(), pwdLevel);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    json.failed("\u67e5\u8be2\u51fa\u9519");
                    return json;
                }
                if (StringUtils.isNotBlank((String)tip)) {
                    json.setStatus(3);
                    json.setMessage(tip);
                    json.put((Object)"url", (Object)"http://");
                    json.put((Object)"tenant", (Object)tenant.getTenantName());
                    json.put((Object)"usertype", (Object)user.getTypeId());
                    json.put((Object)"user", (Object)user);
                    return json;
                }
                String tenantDefaultPwdSQL = "select defaultpwd from pub_defaultpwd where tenant_id=?";
                String tenantDefaultPassword = (String)this.getJdbcTemplate().queryForObject(tenantDefaultPwdSQL, String.class, new Object[]{user.getTenantId()});
                if (tenantDefaultPassword != null && this.mustModifyDefaultPwd(user.getTenantId()) && (defaultPwd = PasswordUtils.encodePasswordByUserCode((String)(sha1DefaultPwd = Encodes.encodeHex((byte[])Digests.sha1((byte[])tenantDefaultPassword.getBytes()))), (String)user.getSalt(), (String)user.getUserCode())).equals(checkPwd)) {
                    json.setStatus(2);
                    json.setMessage("\u4f7f\u7528\u9ed8\u8ba4\u5bc6\u7801\u767b\u9646\uff0c\u8bf7\u4fee\u6539\u5bc6\u7801");
                    json.put((Object)"tenant", (Object)tenant.getTenantName());
                    json.put((Object)"usertype", (Object)user.getTypeId());
                    json.put((Object)"user", (Object)user);
                    return json;
                }
            } else {
                if (this.getPasswordPolicyUtils().isLock(pwdLevel)) {
                    String cacheKey = "errorPasswordCount_" + user.getUserId();
                    Integer count = (Integer)this.getCacheManager().get(cacheKey);
                    if (count == null) {
                        this.getCacheManager().putTimedCache(cacheKey, (Serializable)Integer.valueOf(1), 3600);
                    } else {
                        if (this.getPasswordPolicyUtils().isExceedErrorPasswordCount(pwdLevel, count + 1)) {
                            this.getPasswordPolicyUtils().lockUser(user.getUserId());
                            this.getCacheManager().removeCache(cacheKey);
                            return json.failedWithReturn("\u5bc6\u7801\u8f93\u9519\u6b21\u6570\u8d85\u8fc7" + pwdLevel.getErrorloginthreshold() + "\u6b21\uff0c\u8d26\u6237\u88ab\u9501\u5b9a");
                        }
                        Long ttl = this.getCacheManager().getTTL(cacheKey);
                        Integer localInteger1 = count;
                        Integer localInteger2 = count = Integer.valueOf(count + 1);
                        this.getCacheManager().putTimedCache(cacheKey, (Serializable)count, ttl.intValue());
                    }
                }
                json.failed("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
                return json;
            }
            PerformanceLoggerCollector.stop((String)"queryPasswordPolicy");
            json.success("\u8ba4\u8bc1\u6210\u529f");
            json.put((Object)"tenant", (Object)tenant.getTenantName());
            json.put((Object)"usertype", (Object)user.getTypeId());
            PerformanceLoggerCollector.start((String)"fromObject");
            json.put((Object)"user", (Object)user);
            PerformanceLoggerCollector.stop((String)"fromObject");
            PerformanceLoggerCollector.stop((String)"validateUser");
            errorMsg = this.validateRes(tenant, user, systemId, null);
            if (StringUtils.isNotBlank((String)errorMsg)) {
                return json.failedWithReturn(errorMsg);
            }
        } else {
            json.failed("\u7528\u6237\u6216\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        return json;
    }

    public String validateTenant(Tenant tenant, TenantUser user, HttpServletRequest request) {
        if (tenant != null && tenant.getTenantStates() == 0) {
            return "\u79df\u6237\u672a\u6fc0\u6d3b\uff0c\u8bf7\u901a\u8fc7\u90ae\u7bb1\u7684\u94fe\u63a5\u6fc0\u6d3b\u79df\u6237";
        }
        return null;
    }

    public String validateRes(Tenant tenant, TenantUser user, String systemCode, HttpServletRequest request) {
        String errorMsg = new String();
        if (StringUtils.isNotBlank((String)systemCode)) {
            if (systemCode.equals("tenantuser") || systemCode.equals("tenant")) {
                if (user.getTypeId() == 3) {
                    errorMsg = "\u666e\u901a\u7528\u6237\u53ea\u80fd\u767b\u5f55\u5df2\u8d2d\u4e70\u7684\u5e94\u7528";
                }
            } else if (this.getResGroupService().isGroupCode(systemCode)) {
                String[] resCodes;
                for (String resCode : resCodes = this.getResGroupService().getResCodes(systemCode)) {
                    errorMsg = this.validateSingleRes(tenant, user, resCode, request);
                    if (!StringUtils.isBlank((String)errorMsg)) continue;
                    return null;
                }
            } else {
                errorMsg = this.validateSingleRes(tenant, user, systemCode, request);
            }
            if (StringUtils.isNotBlank((String)errorMsg)) {
                return errorMsg;
            }
        } else {
            return "\u6ca1\u6709\u6b64\u5e94\u7528";
        }
        return null;
    }

    public String validateSingleRes(Tenant tenant, TenantUser user, String systemCode, HttpServletRequest request) {
        String errorMsg = new String();
        int code = this.getResTenantService().isNeedTenant(systemCode);
        if (code == 2) {
            errorMsg = "\u6ca1\u6709\u6b64\u5e94\u7528";
            return errorMsg;
        }
        if (code == 1) {
            TenantRes res;
            if (tenant == null) {
                return "\u8be5\u5e94\u7528\u9700\u8981\u6709\u76f8\u5e94\u6743\u9650\u624d\u80fd\u767b\u5f55";
            }
            try {
                PerformanceLoggerCollector.start((String)"queryTenantRes");
                res = this.getTenantResService().findByTenantIdAndSystemCode2(user.getTenantId(), systemCode);
                PerformanceLoggerCollector.stop((String)"queryTenantRes");
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return "\u67e5\u8be2\u51fa\u9519";
            }
            if (res == null) {
                errorMsg = "\u6ca1\u6709\u6b64\u5e94\u7528";
                return errorMsg;
            }
            String checkTenantRes = PropertyUtil.getPropertyByKey((String)"validate.checkTenantRes");
            boolean isCheckTenantRes = Boolean.valueOf(checkTenantRes);
            if (isCheckTenantRes) {
                if (0 == res.getStates()) {
                    errorMsg = "\u5e94\u7528\u8fd8\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u521d\u59cb\u5316\u5e94\u7528";
                    return errorMsg;
                }
                if (2 == res.getStates()) {
                    errorMsg = "\u5e94\u7528\u521d\u59cb\u5316\u5931\u8d25";
                    return errorMsg;
                }
            }
            if (user.getTypeId() != 1) {
                boolean hasPerssion;
                try {
                    if (!DateUtils.after((String)res.getEndDate())) {
                        errorMsg = "\u8bf7\u5148\u7eed\u79df\u8be5\u5e94\u7528";
                        return errorMsg;
                    }
                }
                catch (ParseException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    return "\u8f6c\u5316\u51fa\u9519";
                }
                try {
                    PerformanceLoggerCollector.start((String)"queryPermission");
                    hasPerssion = this.getUserPermissionService().havePermission(user.getUserId(), systemCode);
                    PerformanceLoggerCollector.stop((String)"queryPermission");
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    return "\u67e5\u8be2\u51fa\u9519";
                }
                if (!hasPerssion) {
                    errorMsg = "\u5f53\u524d\u7528\u6237\u65e0\u6743\u9650";
                    return errorMsg;
                }
            }
        }
        return errorMsg;
    }

    private boolean mustModifyDefaultPwd(String tenantId) {
        String sql = "SELECT t.tenant_pwdpolicy from pub_tenant t where t.tenant_id = ?";
        String passwordPolicy = (String)this.getJdbcTemplate().queryForObject(sql, String.class, new Object[]{tenantId});
        if (StringUtils.isBlank((String)passwordPolicy)) {
            passwordPolicy = "5c5865ce-cf83-4b0d-bc7d-5fae9da95701";
        }
        sql = "SELECT t.force_modify_default_pwd from pub_passwordlevel t where t.pwdlevel_id = ?";
        String forceModifyDefaultPwd = (String)this.getJdbcTemplate().queryForObject(sql, String.class, new Object[]{passwordPolicy});
        return !"N".equals(forceModifyDefaultPwd);
    }
}

