/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.tenant.utils;

import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.yonyou.iuap.security.esapi.IUAPESAPI;
import com.yonyou.uap.tenant.utils.CasPropertyUtil;
import com.yonyou.uap.tenant.utils.HttpRequest;
import com.yonyou.uap.tenant.utils.JsonResponse;
import com.yonyou.uap.tenant.utils.LoginRestUtil;
import com.yonyou.uap.tenant.utils.TenantPasswordEncoder;
import com.yonyou.uap.tenant.web.filter.PerformanceLoggerCollector;
import java.io.Serializable;
import java.net.ConnectException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.authentication.ModifyPWFailedException;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springside.modules.mapper.JsonMapper;
import uap.web.cache.CacheManager;
import uap.web.core.ContextHolder;
import uap.web.utils.HttpTookit;
import uap.web.utils.RSAUtils;
import uap.web.utils.sign.SignEntity;
import uap.web.utils.sign.SignMake;

/*
 * Exception performing whole class analysis ignored.
 */
public class UserValidate {
    private static final Logger logger = LoggerFactory.getLogger(UserValidate.class);
    private static final Gson gson = new Gson();
    private static final String USERPWD_LOGIN_TYPE = "0";

    public static String validate(UsernamePasswordCredential credential, JdbcTemplate jdbcTemplate) throws PreventedException {
        PerformanceLoggerCollector.start((String)"UserValidate");
        if ("0".equals(credential.getIs_security_ca())) {
            UserValidate.randomValidate((UsernamePasswordCredential)credential);
        }
        String verify_code = credential.getVerify_code();
        String username = credential.getUsername();
        String password = credential.getPassword();
        HashMap<String, String> params = new HashMap<String, String>();
        String url = UserValidate.getValidateURL((String)verify_code, (JdbcTemplate)jdbcTemplate);
        if ("0".equals(credential.getIs_security_ca()) && password.contains("_encrypted")) {
            password = RSAUtils.decryptStringByJs((String)password.replace("_encrypted", ""));
        }
        params.put("userName", username);
        params.put("userPassword", password);
        params.put("systemId", credential.getSysid());
        String result = "";
        try {
            LoginRestUtil loginRestUtil = (LoginRestUtil)ContextHolder.getContext().getBean("loginRestUtil");
            JsonResponse jsonResponse = loginRestUtil.userValidateService(username, password, credential.getSysid());
            result = gson.toJson((Object)jsonResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(MDC.get((String)"callid") + e);
            logger.error(MDC.get((String)"callid") + ":userName-" + username);
            logger.error(MDC.get((String)"callid") + ":userPassword-" + password);
            logger.error(MDC.get((String)"callid") + ":systemId-" + credential.getSysid());
            RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", (Object)"\u7cfb\u7edf\u8fde\u63a5\u5f02\u5e38");
            throw new PreventedException("\u7cfb\u7edf\u8fde\u63a5\u5f02\u5e38", (Throwable)e);
        }
        logger.info("\u8fd4\u56de\u4fe1\u606f\uff1a " + result);
        PerformanceLoggerCollector.stop((String)"UserValidate");
        return result;
    }

    private static void randomValidate(UsernamePasswordCredential credential) throws PreventedException {
        String randomvalue = credential.getRandomvalue();
        CacheManager cacheManager = (CacheManager)ContextHolder.getContext().getBean("cacheManager");
        if (!cacheManager.exists("tmp_sso_random_" + randomvalue).booleanValue()) {
            RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", (Object)"\u7cfb\u7edf\u8fde\u63a5\u6709\u6548\u6027\u8fc7\u671f\uff0c\u91cd\u65b0\u767b\u5f55");
            throw new PreventedException("", (Throwable)new Exception());
        }
    }

    public static String modifyPW(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        UserValidate.randomValidate((UsernamePasswordCredential)credential);
        UserValidate.validatePhoneCode((UsernamePasswordCredential)credential);
        String username = credential.getUsername();
        String password = credential.getPassword();
        String newpassword = credential.getNewpass();
        String systemId = credential.getSysid();
        password = password.replace("_encrypted", "");
        password = RSAUtils.decryptStringByJs((String)password);
        password = new TenantPasswordEncoder("SHA1-SALT").encode(credential.getSalt(), password, username);
        newpassword = newpassword.replace("_encrypted", "");
        newpassword = RSAUtils.decryptStringByJs((String)newpassword);
        PublicKey publicKey = UserValidate.getPublicKey();
        password = RSAUtils.encryptString((PublicKey)publicKey, (String)password);
        newpassword = RSAUtils.encryptString((PublicKey)publicKey, (String)newpassword);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userName", username);
        params.put("userPassword", password);
        params.put("newPassword", newpassword);
        params.put("systemId", systemId);
        String url = "";
        url = CasPropertyUtil.getPropertyByKey((String)"modifyPW.rest.url");
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new ModifyPWFailedException(username + " need modify password.");
        }
        SignEntity signEntity = SignMake.signEntity((String)url, params, (String)"POST");
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put("sign", signEntity.getSign());
        try {
            return HttpTookit.doPost((String)signEntity.getSignURL(), params, headers);
        }
        catch (ConnectException e) {
            RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", (Object)"\u7cfb\u7edf\u8fde\u63a5\u5f02\u5e38");
            throw new PreventedException("\u7cfb\u7edf\u8fde\u63a5\u5f02\u5e38", (Throwable)e);
        }
    }

    public static void validatePhoneCode(UsernamePasswordCredential credential) throws ModifyPWFailedException, PreventedException {
        String username = credential.getUsername();
        String phoneNum = credential.getPhoneNum();
        String phoneCode = credential.getPhoneCode();
        if (StringUtils.isBlank((CharSequence)phoneCode)) {
            RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", (Object)"\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
        }
        String validateMsgUrl = CasPropertyUtil.getPropertyByKey((String)"validatePhoneCode.url");
        validateMsgUrl = validateMsgUrl + "?phone=" + phoneNum + "&validate=" + phoneCode;
        JSONObject param = new JSONObject();
        param.put("phone", (Object)phoneNum);
        param.put("validate", (Object)phoneCode);
        String httpResult = HttpRequest.sendPost2((String)validateMsgUrl, (String)param.toString());
        JSONObject obj = JSONObject.parseObject((String)httpResult);
        String status = obj.getString("status");
        String msg = obj.getString("msg");
        if ("0".equals(status)) {
            RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", (Object)msg);
            RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_fail", (Object)true);
            throw new ModifyPWFailedException(username + " need modify password.");
        }
    }

    private static String getValidateURL(String verify_code, JdbcTemplate jdbcTemplate) throws PreventedException {
        String key = "osp_sso_validate_url";
        CacheManager cacheManager = (CacheManager)ContextHolder.getContext().getBean("cacheManager");
        String validateurl = (String)((Object)cacheManager.get(key));
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{validateurl})) {
            return validateurl;
        }
        String sql = " select verify_url from pub_verify WHERE verify_code =? ";
        String url = null;
        try {
            verify_code = IUAPESAPI.encoder().sqlEncode(verify_code, CasPropertyUtil.getDataBaseCodec());
            url = (String)jdbcTemplate.queryForObject(sql, String.class, new Object[]{verify_code});
            cacheManager.setex(key, (Serializable)((Object)url), 1800);
            return url;
        }
        catch (Exception e) {
            RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", (Object)("\u672a\u627e\u5230\u7cfb\u7edf\u4ee3\u7801" + verify_code));
            throw new PreventedException("", (Throwable)e);
        }
    }

    public static PublicKey getPublicKey() throws PreventedException {
        String publickey = "temp_sso_publicKey";
        CacheManager cacheManager = (CacheManager)ContextHolder.getContext().getBean("cacheManager");
        RSAPublicKey pubKey = (RSAPublicKey)cacheManager.get(publickey);
        if (pubKey == null) {
            pubKey = UserValidate.getKeyFromRemote();
            cacheManager.setex(publickey, (Serializable)pubKey, 1800);
        }
        return pubKey;
    }

    private static RSAPublicKey getKeyFromRemote() throws PreventedException {
        String url = "";
        url = CasPropertyUtil.getPropertyByKey((String)"pubkey.rest.url");
        SignEntity signEntity = SignMake.signEntity((String)url, null, (String)"GET");
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put("sign", signEntity.getSign());
        try {
            String result = HttpTookit.doGet((String)signEntity.getSignURL(), null, headers);
            JsonMapper objectMapper = new JsonMapper();
            Map map = (Map)objectMapper.fromJson(result, Map.class);
            String publicKeyExponent = map.get("exponent").toString();
            String publicKeyModulus = map.get("modulus").toString();
            return RSAUtils.generateRSAPublicKey((String)publicKeyModulus, (String)publicKeyExponent);
        }
        catch (ConnectException e) {
            RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", (Object)"\u7cfb\u7edf\u8fde\u63a5\u5f02\u5e38");
            throw new PreventedException("\u7cfb\u7edf\u8fde\u63a5\u5f02\u5e38", (Throwable)e);
        }
    }
}

