/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.tenant.web.filter;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.MDC;
import org.springframework.util.StopWatch;

/*
 * Exception performing whole class analysis ignored.
 */
public class PerformanceLoggerCollector {
    public static final String REQUEST = "request";
    public static final String MYSQL = "mysql";
    public static final String REDIS = "redis";
    public static final String SERIZALIZE = "serizalize";
    public static final String HTTPCLIENT = "httpClient";
    private Map<String, StopWatch> stopWatchMap;
    private StringBuilder logMessages = new StringBuilder();
    private static ThreadLocal<PerformanceLoggerCollector> threadLocal = new ThreadLocal();

    PerformanceLoggerCollector() {
        this.stopWatchMap = new LinkedHashMap();
        this.stopWatchMap.put("request", new StopWatch("request"));
        this.stopWatchMap.put("mysql", new StopWatch("mysql"));
        this.stopWatchMap.put("redis", new StopWatch("redis"));
        this.stopWatchMap.put("serizalize", new StopWatch("serizalize"));
        this.stopWatchMap.put("httpClient", new StopWatch("httpClient"));
    }

    public static void init() {
        threadLocal.set(new PerformanceLoggerCollector());
    }

    public static void start(String watchId, String message) {
        PerformanceLoggerCollector collector = (PerformanceLoggerCollector)threadLocal.get();
        if (collector != null) {
            StopWatch watch = (StopWatch)collector.stopWatchMap.get(watchId);
            if (watch == null) {
                watch = new StopWatch(watchId);
                collector.stopWatchMap.put(watchId, watch);
            }
            try {
                watch.start(message);
            }
            catch (Exception e) {
                collector.logMessages.append("watch status error\uff1a" + e);
            }
        }
    }

    public static void stop(String watchId) {
        StopWatch watch;
        PerformanceLoggerCollector collector = (PerformanceLoggerCollector)threadLocal.get();
        if (collector != null && (watch = (StopWatch)collector.stopWatchMap.get(watchId)) != null) {
            try {
                watch.stop();
            }
            catch (Exception e) {
                collector.logMessages.append("watch status error\uff1a" + e);
            }
        }
    }

    public static void start(String watchId) {
        PerformanceLoggerCollector.start((String)watchId, null);
    }

    public static String getLogMessage() {
        PerformanceLoggerCollector collector = (PerformanceLoggerCollector)threadLocal.get();
        String message = null;
        if (collector != null) {
            message = collector.toString();
        }
        return message;
    }

    public static void reset() {
        threadLocal.remove();
    }

    public String toString() {
        this.logMessages.append("callid:").append(MDC.get((String)"callid"));
        for (String key : this.stopWatchMap.keySet()) {
            this.logMessages.append(key).append(":").append(((StopWatch)this.stopWatchMap.get(key)).getTotalTimeMillis()).append(" ms\n");
            this.buildLogDetails((StopWatch)this.stopWatchMap.get(key));
        }
        return this.logMessages.toString();
    }

    private void buildLogDetails(StopWatch watch) {
        if (!ArrayUtils.isEmpty((Object[])watch.getTaskInfo())) {
            for (StopWatch.TaskInfo task : watch.getTaskInfo()) {
                this.logMessages.append(task.getTaskName()).append(":").append(task.getTimeMillis()).append(" ms\n");
            }
        }
    }
}

