/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.tenant.web.filter;

import com.yonyou.uap.tenant.web.filter.PerformanceLoggerCollector;
import java.io.IOException;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class RequestLogsFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(RequestLogsFilter.class);
    public static final String CALL_ID = "callid";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpReq = (HttpServletRequest)request;
            boolean withPerformLog = StringUtils.isNotBlank((String)httpReq.getHeader("withlog"));
            try {
                String callerId = httpReq.getHeader(CALL_ID);
                if (StringUtils.isBlank((String)callerId)) {
                    callerId = UUID.randomUUID().toString();
                }
                MDC.put((String)CALL_ID, (String)callerId);
                if (withPerformLog) {
                    String url = httpReq.getRequestURI();
                    PerformanceLoggerCollector.init();
                    PerformanceLoggerCollector.start((String)"request", (String)url);
                }
                filterChain.doFilter(request, response);
                return;
            }
            finally {
                if (withPerformLog) {
                    PerformanceLoggerCollector.stop((String)"request");
                    System.out.println(PerformanceLoggerCollector.getLogMessage());
                    PerformanceLoggerCollector.reset();
                }
                MDC.clear();
            }
        }
        filterChain.doFilter(request, response);
    }

    public void destroy() {
    }
}

