/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.principal.DefaultPrincipalFactory;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.PrincipalFactory;
import org.jasig.cas.authentication.principal.PrincipalResolver;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.StubPersonAttributeDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonDirectoryPrincipalResolver
implements PrincipalResolver {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean returnNullIfNoAttributes;
    @NotNull
    private IPersonAttributeDao attributeRepository = new StubPersonAttributeDao(new HashMap());
    @NotNull
    private PrincipalFactory principalFactory = new DefaultPrincipalFactory();
    private String principalAttributeName;

    public boolean supports(Credential credential) {
        return true;
    }

    public final Principal resolve(Credential credential) {
        HashMap<String, Object> convertedAttributes;
        String principalId;
        block8: {
            Map attributes;
            block7: {
                this.logger.debug("Attempting to resolve a principal...");
                principalId = this.extractPrincipalId(credential);
                if (principalId == null) {
                    this.logger.debug("Got null for extracted principal ID; returning null.");
                    return null;
                }
                this.logger.debug("Creating SimplePrincipal for [{}]", (Object)principalId);
                IPersonAttributes personAttributes = this.attributeRepository.getPerson(principalId);
                attributes = personAttributes == null ? null : personAttributes.getAttributes();
                if (attributes == null || attributes.isEmpty()) {
                    if (!this.returnNullIfNoAttributes) {
                        return this.principalFactory.createPrincipal(principalId);
                    }
                    return null;
                }
                convertedAttributes = new HashMap<String, Object>();
                if (!(credential instanceof UsernamePasswordCredential)) break block7;
                UsernamePasswordCredential ucd = (UsernamePasswordCredential)credential;
                convertedAttributes.put("tenantId", ucd.getTenantid());
                Map map = ucd.getAttrparam();
                if (map == null) break block8;
                for (String key : map.keySet()) {
                    Object value = map.get(key);
                    convertedAttributes.put(key, value);
                }
                break block8;
            }
            for (Map.Entry entry : attributes.entrySet()) {
                String key = (String)entry.getKey();
                List values = (List)entry.getValue();
                if (key.equalsIgnoreCase(this.principalAttributeName)) {
                    if (values.isEmpty()) {
                        this.logger.debug("{} is empty, using {} for principal", (Object)this.principalAttributeName, (Object)principalId);
                        continue;
                    }
                    principalId = values.get(0).toString();
                    this.logger.debug("Found principal attribute value {}; removing {} from attribute map.", (Object)principalId, (Object)this.principalAttributeName);
                    continue;
                }
                convertedAttributes.put(key, values.size() == 1 ? values.get(0) : values);
            }
        }
        return this.principalFactory.createPrincipal(principalId, convertedAttributes);
    }

    public final void setAttributeRepository(IPersonAttributeDao attributeRepository) {
        this.attributeRepository = attributeRepository;
    }

    public void setReturnNullIfNoAttributes(boolean returnNullIfNoAttributes) {
        this.returnNullIfNoAttributes = returnNullIfNoAttributes;
    }

    public void setPrincipalAttributeName(String attribute) {
        this.principalAttributeName = attribute;
    }

    public void setPrincipalFactory(PrincipalFactory principalFactory) {
        this.principalFactory = principalFactory;
    }

    protected String extractPrincipalId(Credential credential) {
        return credential.getId();
    }
}

