/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.logout;

import com.yonyou.uap.tenant.log.CasLog;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.SingleLogoutService;
import org.jasig.cas.logout.DefaultLogoutRequest;
import org.jasig.cas.logout.LogoutManager;
import org.jasig.cas.logout.LogoutManagerImpl;
import org.jasig.cas.logout.LogoutMessageCreator;
import org.jasig.cas.logout.LogoutRequest;
import org.jasig.cas.logout.LogoutRequestStatus;
import org.jasig.cas.services.LogoutType;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.util.CompressionUtils;
import org.jasig.cas.util.http.HttpClient;
import org.jasig.cas.util.http.HttpMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uap.web.core.ContextHolder;

public final class LogoutManagerImpl
implements LogoutManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogoutManagerImpl.class);
    @NotNull
    private final ServicesManager servicesManager;
    @NotNull
    private final HttpClient httpClient;
    @NotNull
    private final LogoutMessageCreator logoutMessageBuilder;
    private boolean singleLogoutCallbacksDisabled;
    private boolean asynchronous = true;

    public LogoutManagerImpl(ServicesManager servicesManager, HttpClient httpClient, LogoutMessageCreator logoutMessageBuilder) {
        this.servicesManager = servicesManager;
        this.httpClient = httpClient;
        this.logoutMessageBuilder = logoutMessageBuilder;
    }

    public void setAsynchronous(boolean asyncCallbacks) {
        this.asynchronous = asyncCallbacks;
    }

    @Deprecated
    public void setIssueAsynchronousCallbacks(boolean asyncCallbacks) {
        this.asynchronous = asyncCallbacks;
        LOGGER.warn("setIssueAsynchronousCallbacks() is deprecated. Use setAsynchronous() instead.");
    }

    public List<LogoutRequest> performLogout(TicketGrantingTicket ticket) {
        CasLog casLog = (CasLog)ContextHolder.getContext().getBean("securityLog");
        casLog.recordLog(ticket);
        Map services = ticket.getServices();
        ArrayList<LogoutRequest> logoutRequests = new ArrayList<LogoutRequest>();
        if (!this.singleLogoutCallbacksDisabled) {
            for (Map.Entry entry : services.entrySet()) {
                LogoutRequest logoutRequest;
                Service service = (Service)entry.getValue();
                if (!(service instanceof SingleLogoutService) || (logoutRequest = this.handleLogoutForSloService((SingleLogoutService)service, (String)entry.getKey(), ticket)) == null) continue;
                LOGGER.debug("Captured logout request [{}]", (Object)logoutRequest);
                logoutRequests.add(logoutRequest);
            }
        }
        return logoutRequests;
    }

    private boolean serviceSupportsSingleLogout(RegisteredService registeredService) {
        return registeredService != null && registeredService.getAccessStrategy().isServiceAccessAllowed() && registeredService.getLogoutType() != LogoutType.NONE;
    }

    private LogoutRequest handleLogoutForSloService(SingleLogoutService singleLogoutService, String ticketId, TicketGrantingTicket ticket) {
        RegisteredService registeredService;
        if (!singleLogoutService.isLoggedOutAlready() && this.serviceSupportsSingleLogout(registeredService = this.servicesManager.findServiceBy((Service)singleLogoutService))) {
            URL logoutUrl = this.determineLogoutUrl(registeredService, singleLogoutService);
            DefaultLogoutRequest logoutRequest = new DefaultLogoutRequest(ticketId, singleLogoutService, logoutUrl);
            LogoutType type = registeredService.getLogoutType() == null ? LogoutType.BACK_CHANNEL : registeredService.getLogoutType();
            switch (type.ordinal()) {
                case 1: {
                    if (this.performBackChannelLogout((LogoutRequest)logoutRequest, ticket)) {
                        logoutRequest.setStatus(LogoutRequestStatus.SUCCESS);
                        break;
                    }
                    logoutRequest.setStatus(LogoutRequestStatus.FAILURE);
                    LOGGER.warn("Logout message not sent to [{}]; Continuing processing...", (Object)singleLogoutService.getId());
                    break;
                }
                default: {
                    logoutRequest.setStatus(LogoutRequestStatus.NOT_ATTEMPTED);
                }
            }
            return logoutRequest;
        }
        return null;
    }

    private URL determineLogoutUrl(RegisteredService registeredService, SingleLogoutService singleLogoutService) {
        try {
            URL serviceLogoutUrl = registeredService.getLogoutUrl();
            if (serviceLogoutUrl != null) {
                LOGGER.debug("Logout request will be sent to [{}] for service [{}]", (Object)serviceLogoutUrl, (Object)singleLogoutService);
            }
            return serviceLogoutUrl;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private boolean performBackChannelLogout(LogoutRequest request, TicketGrantingTicket ticket) {
        try {
            Map params = ticket.getAuthentication().getPrincipal().getAttributes();
            Object userID = params.get("userId");
            String userId = "";
            if (userID != null) {
                userId = userID.toString();
            }
            String logoutRequest = this.logoutMessageBuilder.create(request);
            if (!StringUtils.isBlank((String)userId)) {
                String userStr = "<samlp:UserId>" + userId + "</samlp:UserId>";
                logoutRequest = logoutRequest.replaceAll("</samlp:LogoutRequest>", userStr + "</samlp:LogoutRequest>");
            }
            String newLogoutRequest = logoutRequest;
            SingleLogoutService logoutService = request.getService();
            logoutService.setLoggedOutAlready(true);
            LOGGER.info("Sending logout request for: [{}]", (Object)logoutService.getId());
            LogoutHttpMessage msg = new LogoutHttpMessage(this, request.getLogoutUrl(), newLogoutRequest);
            LOGGER.info("Prepared logout message to send  to [{}] .", (Object)request.getLogoutUrl());
            boolean sendMessageResult = this.httpClient.sendMessageToEndPoint((HttpMessage)msg);
            LOGGER.info("sendMessageResult  [{}] ", (Object)sendMessageResult);
            return sendMessageResult;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public String createFrontChannelLogoutMessage(LogoutRequest logoutRequest) {
        String logoutMessage = this.logoutMessageBuilder.create(logoutRequest);
        LOGGER.trace("Attempting to deflate the logout message [{}]", (Object)logoutMessage);
        return CompressionUtils.deflate((String)logoutMessage);
    }

    public void setSingleLogoutCallbacksDisabled(boolean singleLogoutCallbacksDisabled) {
        this.singleLogoutCallbacksDisabled = singleLogoutCallbacksDisabled;
    }

    static /* synthetic */ boolean access$000(LogoutManagerImpl x0) {
        return x0.asynchronous;
    }
}

