/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import com.yonyou.uap.tenant.utils.CasPropertyUtil;
import java.io.Serializable;
import java.security.interfaces.RSAPublicKey;
import javax.validation.constraints.NotNull;
import org.jasig.cas.util.UniqueTicketIdGenerator;
import org.jasig.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import uap.web.cache.CacheManager;
import uap.web.core.ContextHolder;
import uap.web.utils.PropertyUtil;
import uap.web.utils.RSAUtils;

public class GenerateLoginTicketAction {
    private static final String PREFIX = "LT";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private UniqueTicketIdGenerator ticketIdGenerator;

    public final String generate(RequestContext context) {
        String loginTicket = this.ticketIdGenerator.getNewTicketId(PREFIX);
        this.logger.debug("Generated login ticket {}", (Object)loginTicket);
        WebUtils.putLoginTicket((RequestContext)context, (String)loginTicket);
        this.initPubKeyParams(context);
        RequestContextHolder.getRequestContext();
        return "generated";
    }

    private void initPubKeyParams(RequestContext context) {
        CacheManager cacheManager = (CacheManager)ContextHolder.getContext().getBean("cacheManager");
        RSAPublicKey publicKey = RSAUtils.getDefaultPublicKey();
        String publicKeyExponent = publicKey.getPublicExponent().toString(16);
        String publicKeyModulus = publicKey.getModulus().toString(16);
        context.getFlowScope().put("exponent", (Object)publicKeyExponent);
        context.getFlowScope().put("modulus", (Object)publicKeyModulus);
        String url = this.getregisterURL();
        context.getFlowScope().put("registerurl", (Object)url);
        String tocRegisterUrl = this.getTocRegisterURL();
        context.getFlowScope().put("registeruserurl", (Object)tocRegisterUrl);
        String simpleRegisterUrl = this.getSimpleRegisterURL();
        context.getFlowScope().put("simpleregisterurl", (Object)simpleRegisterUrl);
        String forgeturl = this.getForgetURL();
        context.getFlowScope().put("forgeturl", (Object)forgeturl);
        String systemid = context.getRequestParameters().get("sysid");
        context.getFlowScope().put("systemid", (Object)systemid);
        String randomvaule = String.valueOf(System.currentTimeMillis());
        context.getFlowScope().put("randomvalue", (Object)randomvaule);
        cacheManager.setex("tmp_sso_random_" + randomvaule, (Serializable)((Object)randomvaule), 600);
        String sendPhoneCodeUrl = this.getSendPhoneCodeURL();
        context.getFlowScope().put("sendPhoneCodeUrl", (Object)sendPhoneCodeUrl);
    }

    private String getSimpleRegisterURL() {
        return CasPropertyUtil.getPropertyByKey((String)"simpleregister.url");
    }

    private String getregisterURL() {
        return CasPropertyUtil.getPropertyByKey((String)"register.url");
    }

    private String getTocRegisterURL() {
        return CasPropertyUtil.getPropertyByKey((String)"tocregister.url");
    }

    private String getForgetURL() {
        return PropertyUtil.getPropertyByKey((String)"forgetpw.url");
    }

    private String getSendPhoneCodeURL() {
        return CasPropertyUtil.getPropertyByKey((String)"sendPhoneCode.url");
    }

    public void setTicketIdGenerator(UniqueTicketIdGenerator generator) {
        this.ticketIdGenerator = generator;
    }
}

