/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.SimpleWebApplicationServiceImpl;
import org.jasig.cas.logout.LogoutRequest;
import org.jasig.cas.logout.LogoutRequestStatus;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.web.flow.AbstractLogoutAction;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public final class LogoutAction
extends AbstractLogoutAction {
    @NotNull
    private ServicesManager servicesManager;
    private boolean followServiceRedirects;

    protected Event doInternalExecute(HttpServletRequest request, HttpServletResponse response, RequestContext context) throws Exception {
        SimpleWebApplicationServiceImpl webAppService;
        RegisteredService rService;
        boolean needFrontSlo = false;
        this.putLogoutIndex(context, 0);
        List logoutRequests = WebUtils.getLogoutRequests((RequestContext)context);
        if (logoutRequests != null) {
            for (LogoutRequest logoutRequest : logoutRequests) {
                if (logoutRequest.getStatus() != LogoutRequestStatus.NOT_ATTEMPTED) continue;
                needFrontSlo = true;
                break;
            }
        }
        String service = request.getParameter("service");
        if (this.followServiceRedirects && service != null && (rService = this.servicesManager.findServiceBy((Service)(webAppService = new SimpleWebApplicationServiceImpl(service)))) != null && rService.getAccessStrategy().isServiceAccessAllowed()) {
            context.getFlowScope().put("logoutRedirectUrl", (Object)service);
        }
        if (needFrontSlo) {
            return new Event((Object)this, "front");
        }
        return new Event((Object)this, "finish");
    }

    public void setFollowServiceRedirects(boolean followServiceRedirects) {
        this.followServiceRedirects = followServiceRedirects;
    }

    public void setServicesManager(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }
}

