/*
 * Decompiled with CFR 0.152.
 */
package uap.web.utils;

import com.yonyou.uap.tenant.utils.CasPropertyUtil;
import com.yonyou.uap.tenant.web.filter.PerformanceLoggerCollector;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpTookit {
    private static final Logger logger = LoggerFactory.getLogger(HttpTookit.class);
    static RequestConfig config = null;
    static PoolingHttpClientConnectionManager cm = null;
    private static final CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).setConnectionManager((HttpClientConnectionManager)cm).build();
    public static final String CHARSET = "UTF-8";

    public static String doGet(String url, Map<String, String> params) throws ConnectException {
        return HttpTookit.doGet((String)url, params, null, (String)"UTF-8");
    }

    public static String doPost(String url, Map<String, String> params) throws ConnectException {
        return HttpTookit.doPost((String)url, params, null, (String)"UTF-8");
    }

    public static String doGet(String url, Map<String, String> params, Map<String, String> headers) throws ConnectException {
        return HttpTookit.doGet((String)url, params, headers, (String)"UTF-8");
    }

    public static String doPost(String url, Map<String, String> params, Map<String, String> headers) throws ConnectException {
        return HttpTookit.doPost((String)url, params, headers, (String)"UTF-8");
    }

    public static String doPost(String url, String requestBody, Map<String, String> headers) throws ConnectException {
        HttpPost httpPost = null;
        CloseableHttpResponse response = null;
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        try {
            PerformanceLoggerCollector.start((String)"httpClient", (String)"post");
            Object pairs = null;
            httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)new StringEntity(requestBody));
            if (headers == null) {
                headers = new HashMap<String, String>();
            }
            HttpTookit.addCallerId(headers);
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPost.addHeader(entry.getKey(), entry.getValue());
            }
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(10000).setConnectTimeout(10000).build();
            httpPost.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                Object[] errorHeaders = response.getHeaders("restful validate error");
                if (!ArrayUtils.isEmpty((Object[])errorHeaders)) {
                    logger.error(errorHeaders[0].getValue());
                }
                httpPost.abort();
                throw new ConnectException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            }
            EntityUtils.consume((HttpEntity)entity);
            PerformanceLoggerCollector.stop((String)"httpClient");
            String string = result;
            return string;
        }
        catch (IOException | ParseException e) {
            logger.error("http do get exception:", e);
            throw new ConnectException(e.getMessage());
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (httpPost != null) {
                    httpPost.releaseConnection();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String doGet(String url, Map<String, String> params, Map<String, String> headers, String charset) throws ConnectException {
        HttpGet httpGet = null;
        CloseableHttpResponse response = null;
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        try {
            if (params != null && !params.isEmpty()) {
                List pairs = HttpTookit.genkeyPairs(params);
                url = url + "?" + EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(pairs, charset));
            }
            if (headers == null) {
                headers = new HashMap<String, String>();
            }
            HttpTookit.addCallerId(headers);
            PerformanceLoggerCollector.start((String)"httpClient", (String)"get");
            httpGet = new HttpGet(url);
            if (!headers.isEmpty()) {
                for (Map.Entry entry : headers.entrySet()) {
                    httpGet.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(10000).setConnectTimeout(10000).setCookieSpec("ignoreCookies").build();
            httpGet.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpGet);
            int n = response.getStatusLine().getStatusCode();
            if (n != 200) {
                httpGet.abort();
                throw new ConnectException("HttpClient,error status code :" + n);
            }
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            }
            EntityUtils.consume((HttpEntity)entity);
            PerformanceLoggerCollector.stop((String)"httpClient");
            String string = result;
            return string;
        }
        catch (IOException | ParseException e) {
            logger.error("http do get exception:", e);
            throw new ConnectException(e.getMessage());
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (httpGet != null) {
                    httpGet.releaseConnection();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String doPost(String url, Map<String, String> params, Map<String, String> headers, String charset) throws ConnectException {
        HttpPost httpPost = null;
        CloseableHttpResponse response = null;
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        try {
            PerformanceLoggerCollector.start((String)"httpClient", (String)"post");
            List pairs = null;
            if (params != null && !params.isEmpty()) {
                pairs = HttpTookit.genkeyPairs(params);
            }
            httpPost = new HttpPost(url);
            if (pairs != null && pairs.size() > 0) {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, "UTF-8"));
            }
            if (headers == null) {
                headers = new HashMap<String, String>();
            }
            HttpTookit.addCallerId(headers);
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPost.addHeader(entry.getKey(), entry.getValue());
            }
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(10000).setConnectTimeout(10000).build();
            httpPost.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                Object[] errorHeaders = response.getHeaders("restful validate error");
                if (!ArrayUtils.isEmpty((Object[])errorHeaders)) {
                    logger.error(errorHeaders[0].getValue());
                }
                httpPost.abort();
                throw new ConnectException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            }
            EntityUtils.consume((HttpEntity)entity);
            PerformanceLoggerCollector.stop((String)"httpClient");
            String string = result;
            return string;
        }
        catch (IOException | ParseException e) {
            logger.error("http do get exception:", e);
            throw new ConnectException(e.getMessage());
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (httpPost != null) {
                    httpPost.releaseConnection();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static List<NameValuePair> genkeyPairs(Map<String, String> params) {
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        if (!CollectionUtils.isEmpty(params)) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String value = entry.getValue();
                if (value == null) continue;
                pairs.add((NameValuePair)new BasicNameValuePair(entry.getKey(), value));
            }
        }
        return pairs;
    }

    private static void addCallerId(Map<String, String> headers) {
        headers.put("callid", MDC.get((String)"callid"));
    }

    static {
        String MaxTotal = CasPropertyUtil.getPropertyByKey((String)"httpclient.MaxTotal");
        String MaxPerRoute = CasPropertyUtil.getPropertyByKey((String)"httpclient.MaxPerRoute");
        if (StringUtils.isBlank((String)MaxTotal) || !StringUtils.isNumeric((String)MaxTotal)) {
            MaxTotal = "1000";
        }
        if (StringUtils.isBlank((String)MaxPerRoute) || !StringUtils.isNumeric((String)MaxPerRoute)) {
            MaxPerRoute = "1000";
        }
        config = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(10000).build();
        cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(Integer.valueOf(MaxTotal).intValue());
        cm.setDefaultMaxPerRoute(Integer.valueOf(MaxPerRoute).intValue());
    }
}

