var CasUtils = {};
(function(utils) {
	utils.CONTEXT_KEY = "CAS_ICOP_CONTEXT";
	utils.GETWORKBENCHCONTEXT = "/icop-workbench/getWorkbenchCookie";
	utils.ICOP_WORKBENCH_WEB = "/icop-workbench";
	utils.ICOP_USERCENTER_WEB = "/icop-usercenter-web/";
	utils.isJsonStr = function(val) {
		return (typeof val == "string" && /^\{.*\}$/.test(val));
	};
	utils.init = function(options){
		var _url = options && options.url || utils.GETWORKBENCHCONTEXT;
		var _success = options && options.success;
		var _error = options && options.error;
		$.ajax({
			type: 'GET',
			url: _url,
			dataType : 'jsonp',
			async: false,
			success: function(data) {
				//写入cookie
				window.sessionStorage.setItem(utils.CONTEXT_KEY, JSON.stringify(data));
				if(_success) {
					_success();
				}
			},
			error: function(data) {
				if(_error) {
					_error();
				}
			}
		});
	};
	utils.getContext = function() {
		var context = window.sessionStorage.getItem(utils.CONTEXT_KEY);
		if (this.isJsonStr(context)) {// 确保为JSON格式的字符串
			var jsTxt = '(' + context.replace(/'/, "\'") + ')';
			var jsonObj = eval(jsTxt);// 转换为JSON对象
			return jsonObj;
		}
	};
	utils.getHeader = function() {
		var includeFields = [ "u_logints", "u_usercode", "token", "tenantid",
				"userId", "userType", "typeAlias"// 认证需要的字段，下面为扩展字段
				, "_A_P_userLoginName", "_A_P_userName", "userType",
				"companyId", "companyName", "companyCode" ];
		var set = new Set();
		includeFields.forEach(function(value) {
			set.add(value);
		});

		var authentication = '';
		var context = this.getContext();
		if (context) {
			for ( var prop in context) {
				if (set.has(prop) && context[prop]) {
					authentication += prop + '=' + encodeURI(context[prop])
							+ ';';
				}
			}
		}
		if (authentication.length > 0
				&& authentication[authentication.length - 1] == ';')
			authentication = authentication.substring(0,
					authentication.length - 1);
		return authentication;
	};
	utils.request = function(option) {
		var _this = this;
		var success = function() {
			$.ajax({
				type : option.type,
				url : option.url,
				dataType : option.dataType,
				async : option.async,
				headers : {
					'authority' : _this.getHeader()
				},
				success : function(data) {
					option.success(data);
				}, 
				error : function(data) {
					option.error(data);
				}
			});
		}
		
		if(this.getHeader()) {
			success();
			return;
		}
		
		var error = function() {
			alert('认证信息失效');
		}
		var options = {};
		options.success = success;
		options.error = error;
		this.init(options);
	}

}(CasUtils));