/**
*serverUri:服务端URI
*receiveUri:接收的URI
*json : 传入验证的json{"rentierid":"1001","appid":"","user":"","receiveuri":"identity+本地IP+登录用户名（如：1001-127.0.0.1-fjz）"}
*fn：回调函数
**/
function receive(host,port,serverUri,receiveUri,json,callback){
	var host = host || "localhost";
	var port = port || "8080";
	var json = json || {};
	
	if (typeof callback !== 'function') {
      return;
    }
	
	var url = "http://"+host+":"+port+"/eventbus";
	var eb = new EventBus(url);

	eb.onopen = function () {
				
		//消息处理
		eb.send(serverUri, json, function(err, reply) {
//			console.log("start send msg");
			if (err) {
//				console.error('Failed to retrieve albums: ' + err);
				//callback(err,reply);
				return;
			}
			var msg = reply.body;
//			console.log(msg);
			
			//注册处理
			eb.registerHandler(receiveUri, function (err, msg) {
				if (err) {
//					console.error('Failed to registerHandler: ' + err);
					callback(err,msg);
					return;
				}
				//回调函数调用							
				callback(err,msg);
			});
		});
	}
}

var Message = {};
(function(m){

	//var eb = null;

	m.subscribe_bak = function(host,port,serverUri,receiveUri,json,callback){
		var host = host || "localhost";
		var port = port || "8080";
		var json = json || {};
		if ((serverUri == null || serverUri == undefined || serverUri == '')
			|| (receiveUri == null || receiveUri == undefined || receiveUri == '')) {
			var err="传入的参数不正确";
//			console.error('描述：' + err);
			return;
		}
		
		if (typeof callback !== 'function') {
		  return;
		}
		
		var url = "http://"+host+":"+port+"/eventbus";
		eb = new EventBus(url);

		eb.onopen = function () {
					
			//消息处理
			eb.send(serverUri, json, function(err, reply) {
//				console.log("start send msg");
				if (err) {
//					console.error('Failed to retrieve albums: ' + err);
					//callback(err,reply);
					return;
				}
				var msg = reply.body;
//				console.log(msg);
				
				//注册处理
				eb.registerHandler(receiveUri, function (err, msg) {
					if (err) {
//						console.error('Failed to registerHandler: ' + err);
						callback(err,msg);
						return;
					}
					//回调函数调用							
					callback(err,msg);
				});
			});
		}
	};
	
	//注销eventBus
	//"receiveuri":"identity+本地IP+登录用户名
	m.unregister_bak = function(receiveUri){
		if(eb==null){
			return;
		}
		//eb.unregisterHandler(receiveUri,{},function(err,msg){
		//	callback(err,msg);
		//});
		eb.unregisterHandler(receiveUri,{});	
	}
	
	m.subscribe = function(json,callback){
		//console.log("json="+json.userkey);
		var json = json || {};
		var serverUri = json.identity || "yonyou.vertx.server1";
		var user= json.userkey||"vertx";
		var baseHost = json.baseHost||"http://172.16.72.14:8081";
		var receiveUri = serverUri+"-"+user;
		
		if ((serverUri == null || serverUri == undefined || serverUri == '')
			|| (receiveUri == null || receiveUri == undefined || receiveUri == '')) {
			var err="传入的参数不正确";
//			console.error('描述：' + err);
			return;
		}
		
		if(typeof callback !== 'function') {
		  return;
		}
		// var url = "http://"+host+":"+port+"/eventbus";
		var url = baseHost+"/eventbus";
		var eb = null;  //测试用
		if(eb==null){
			eb = new EventBus(url);
		}

		eb.onopen = function () {
			//消息处理
			eb.send(serverUri, json, function(err, reply) {
				console.log("start send msg serverUri"+json.userkey);
				if (err) {
					console.error('Failed to retrieve albums: ' + err);
					return;
				}
				var msg = reply.body;
				console.log(msg);

                //注册处理
                eb.registerHandler(receiveUri, function (err, msg) {
                    if (err) {
                        console.error('Failed to registerHandler: ' + err);
                        callback(err,msg);
                        return;
                    }
                    const body = msg.body;
                    const message = body.message;

                    var msgObj = JSON.parse(message);
                    if (msgObj && msgObj.type === 'logout') {
                        var keys = document.cookie.match(/[^ =;]+(?=\=)/g);
                        if(keys) {
                            for(var i=keys.length; i--;){
                                document.cookie = keys[i] + '=0;expires=' + new Date(0).toUTCString()
                            }
                        }

                        sessionStorage['AUTHORITY_BUTTON'] = "";
                        sessionStorage['SELECT_ROLE_CACHE'] = "";
                        window.location.href=window.contextRoot+"/sso/logout";

                    }

                    //回调函数调用
                    callback(err,msg.body);
                });
			});


		}
		
	};
	
	//注销eventBus
	//"receiveuri":"identity+本地IP+登录用户名
	m.unregister = function(json){
		if(eb==null){
			return;
		}
		
		var serverUri = json.identity || "yonyou.vertx.server1";
		var user= json.userkey||"vertx";
		var receiveUri = serverUri+"-"+user;
		
		eb.unregisterHandler(receiveUri,{});	
	}
		
}(Message));



  