/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.construction.icop.config;

import com.yonyou.construction.icop.config.utils.IcopConfigUtils;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class IcopPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(IcopPropertyPlaceholderConfigurer.class);
    private boolean local = false;

    protected Properties mergeProperties() throws IOException {
        Properties result = new Properties();
        if (this.local) {
            log.error("read-properties-from-local");
            result = super.mergeProperties();
        } else {
            log.error("read-properties-from-config-server");
            result = this.getFromServer();
        }
        return result;
    }

    private Properties getFromServer() throws IOException {
        return IcopConfigUtils.getFromServer();
    }

    public void afterPropertiesSet() throws Exception {
        this.local = IcopConfigUtils.isReadLocalFile();
    }
}

