/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.construction.icop.config.utils;

import com.yonyou.construction.icop.config.exception.ConfigException;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcopConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(IcopConfigUtils.class);

    public static String getValue(String key) {
        String value = (String)System.getProperties().get(key);
        if (null == value || "".equals(value)) {
            value = System.getenv(key);
        }
        return value;
    }

    public static boolean isReadLocalFile() {
        boolean local = false;
        String profile = IcopConfigUtils.getValue("spring.cloud.config.profile");
        if (null == profile || "".equals(profile)) {
            log.error("profile is null,load properties from local...");
            local = true;
        } else {
            log.error("profile is " + profile + ",load properties from git server");
        }
        return local;
    }

    public static Properties getFromServer() {
        String application;
        String label;
        String profile = IcopConfigUtils.getValue("spring.cloud.config.profile");
        String configServer = IcopConfigUtils.getValue("spring.cloud.config.uri");
        if (null == configServer || "".equals(configServer)) {
            throw new ConfigException("configServer \u914d\u7f6e\u9519\u8bef");
        }
        if (!configServer.endsWith("/")) {
            configServer = configServer + "/";
            log.warn("configServer is " + configServer + ",not end with [/]");
        }
        if ((label = IcopConfigUtils.getValue("spring.cloud.config.label")) == null || "".equals(label)) {
            label = "master";
        }
        if (null == (application = IcopConfigUtils.getValue("spring.cloud.config.name")) || "".equals(application)) {
            throw new ConfigException("applicationName \u914d\u7f6e\u9519\u8bef");
        }
        Properties result = null;
        try {
            result = IcopConfigUtils.getFromServer(configServer, application, profile, label);
        }
        catch (IOException e) {
            throw new ConfigException("\u4ece\u8fdc\u7a0b\u914d\u7f6e\u6587\u4ef6\u670d\u52a1\u5668\u53d6\u4fe1\u606f\u53d1\u751f\u9519\u8bef", e);
        }
        return result;
    }

    public static Properties getFromServer(String configServer, String application, String profile, String label) throws IOException {
        Properties result = new Properties();
        String serverurl = configServer + application + "-" + profile + ".properties";
        List<String> valuelist = IcopConfigUtils.getStringValue(serverurl);
        if (valuelist != null) {
            for (int i = 0; i < valuelist.size(); ++i) {
                String line = valuelist.get(i);
                int splitindex = line.indexOf(":");
                String key = line.substring(0, splitindex);
                String value = line.substring(splitindex + 2);
                result.put(key, value);
            }
        }
        return result;
    }

    private static List<String> getStringValue(String serverurl) {
        InputStream is = null;
        BufferedReader reader = null;
        OutputStream out = null;
        try {
            URL url = new URL(serverurl);
            HttpURLConnection huc = (HttpURLConnection)url.openConnection();
            huc.setDoOutput(true);
            huc.setConnectTimeout(6000);
            huc.setRequestProperty("Content-Type", "text/json; charset=UTF-8");
            huc.setRequestMethod("GET");
            huc.setRequestProperty("Accept", "*/*");
            huc.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; CIBA)");
            huc.setRequestProperty("Accept-Language", "zh-cn");
            huc.connect();
            StringBuffer response = new StringBuffer();
            ArrayList<String> result = new ArrayList<String>(100);
            int code = huc.getResponseCode();
            if (code >= 200 && code < 300) {
                is = huc.getInputStream();
                reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    result.add(line);
                }
                ArrayList<String> arrayList = result;
                return arrayList;
            }
            try {
                throw new ConfigException("\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38:" + serverurl + "," + code);
            }
            catch (Exception e) {
                throw new ConfigException("\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38", e);
            }
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    ((FileOutputStream)out).close();
                }
                catch (IOException e) {
                    throw new ConfigException("out.close", e);
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new ConfigException("reader.close", e);
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new ConfigException("is.close", e);
                }
            }
        }
    }
}

