/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.auth.session;

import com.yonyou.iuap.auth.token.ITokenProcessor;
import com.yonyou.iuap.auth.token.TokenFactory;
import com.yonyou.iuap.cache.utils.SerializUtil;
import com.yonyou.iuap.security.esapi.EncryptException;
import com.yonyou.iuap.security.utils.TokenGenerator;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springside.modules.nosql.redis.JedisTemplate;
import org.springside.modules.nosql.redis.JedisUtils;
import org.springside.modules.nosql.redis.pool.JedisPool;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisException;

public class SessionManager {
    public static final String TOKEN_SEED = "token_seed";
    public static final String SESSION_PREFIX = "IUAP_SESSION_USER:";
    public static final String DEFAULT_CHARSET = "UTF-8";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static String localSeedValue = null;
    private JedisPool sessionJedisPool;
    private boolean sessionMutex = false;

    public JedisPool getSessionJedisPool() {
        return this.sessionJedisPool;
    }

    public void setSessionJedisPool(JedisPool sessionJedisPool) {
        this.sessionJedisPool = sessionJedisPool;
    }

    public boolean isSessionMutex() {
        return this.sessionMutex;
    }

    public void setSessionMutex(boolean sessionMutex) {
        this.sessionMutex = sessionMutex;
    }

    public String findSeed() throws EncryptException {
        if (localSeedValue != null) {
            return localSeedValue;
        }
        String seed = this.getSeedValue(TOKEN_SEED);
        if (StringUtils.isBlank((String)seed)) {
            localSeedValue = seed = TokenGenerator.genSeed();
            this.set(TOKEN_SEED, seed);
        }
        return seed;
    }

    public String getSeedValue(String key) {
        return this.get(key);
    }

    public Map<String, Object> getAllSessionAttrCache(String sid) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Map<byte[], byte[]> redisMap = this.hgetAll(sid);
        for (byte[] byteKey : redisMap.keySet()) {
            String key = new String(byteKey, Charset.forName(DEFAULT_CHARSET));
            Object obj = SerializUtil.byteToObject((byte[])redisMap.get(byteKey));
            hashMap.put(key, obj);
        }
        int timeOut = this.getTimeout(sid);
        if (timeOut > 0) {
            this.expire(sid, timeOut);
        }
        return hashMap;
    }

    public void removeSessionCache(String sid) {
        this.del(sid);
    }

    public <T extends Serializable> void putSessionCacheAttribute(String sid, String key, T value) {
        this.putSessionCacheAttribute(sid, key, value, this.getTimeout(sid));
    }

    public <T extends Serializable> void putSessionCacheAttribute(String sid, String key, T value, int timeout) {
        this.hset(sid, key, value);
        if (timeout > 0) {
            this.expire(sid, timeout);
        }
    }

    public <T extends Serializable> void updateSessionCacheAttribute(String sid, String key, T value) {
        if (this.hexists(sid, key).booleanValue()) {
            this.putSessionCacheAttribute(sid, key, value);
        }
    }

    public Object getSessionCacheAttribute(String sid, String key) {
        Object result = null;
        boolean isExist = this.exists(sid);
        if (isExist) {
            int timeOut = this.getTimeout(sid);
            if (timeOut > 0) {
                this.expire(sid, timeOut);
            }
            result = this.hget(sid, key);
        }
        return result;
    }

    public void removeSessionCacheAttribute(String sid, String key) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sid) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)key)) {
            this.hdel(sid, key);
        }
    }

    private int getTimeout(String sid) {
        return TokenFactory.getTokenInfo(sid).getIntegerExpr();
    }

    public void registOnlineSession(String userid, String token, ITokenProcessor processor) {
        String key = SESSION_PREFIX + userid;
        this.logger.debug("token processor id is {},key is {} !", (Object)processor.getId(), (Object)key);
        boolean mutex = this.isSessionMutex();
        if (mutex) {
            this.deleteUserSession(userid);
        } else {
            this.clearOnlineSession(key);
        }
        String currentTs = String.valueOf(System.currentTimeMillis());
        this.sessionHset(key, token, currentTs);
    }

    private void clearOnlineSession(final String key) {
        final ArrayList<String> deleteKeys = new ArrayList<String>();
        Map<String, String> userSessions = this.getMap(key);
        if (userSessions != null) {
            for (Map.Entry<String, String> entry : userSessions.entrySet()) {
                String t = entry.getKey();
                String v = entry.getValue();
                long exprMillis = this.getTimeout(t) * 1000;
                if (exprMillis <= 0L) continue;
                long cts = System.currentTimeMillis();
                if (Long.parseLong(v) + exprMillis >= cts) continue;
                deleteKeys.add(t);
            }
        }
        JedisTemplate.PipelineActionNoResult action = new JedisTemplate.PipelineActionNoResult(){

            public void action(Pipeline pipeline) {
                for (int i = 0; i < deleteKeys.size(); ++i) {
                    pipeline.hdel(key, new String[]{(String)deleteKeys.get(i)});
                }
            }
        };
        this.execute(action);
    }

    public boolean validateOnlineSession(String userid, final String token) {
        boolean result = false;
        final String key = SESSION_PREFIX + userid;
        final String lastTsStr = this.sessionHget(key, token);
        if (lastTsStr != null) {
            final int timeOut = this.getTimeout(token);
            if (timeOut <= 0) {
                return true;
            }
            final ArrayList pipelineResult = new ArrayList();
            JedisTemplate.PipelineActionNoResult action = new JedisTemplate.PipelineActionNoResult(){

                public void action(Pipeline pipeline) {
                    long exprMillis = timeOut * 1000;
                    if (exprMillis > 0L) {
                        long cts = System.currentTimeMillis();
                        if (Long.parseLong(lastTsStr) + exprMillis >= cts) {
                            pipeline.hset(key, token, String.valueOf(cts));
                            pipeline.expire(token, timeOut);
                            pipelineResult.add(true);
                        } else {
                            pipeline.hdel(key, new String[]{token});
                        }
                    }
                }
            };
            this.execute(action);
            result = pipelineResult.size() > 0;
        }
        return result;
    }

    public void delOnlineSession(String userid, final String token) {
        final String key = SESSION_PREFIX + userid;
        JedisTemplate.PipelineActionNoResult action = new JedisTemplate.PipelineActionNoResult(){

            public void action(Pipeline pipeline) {
                pipeline.del(token);
                pipeline.hdel(key, new String[]{token});
            }
        };
        this.execute(action);
    }

    public void deleteUserSession(String userid) {
        final String key = SESSION_PREFIX + userid;
        final Map<String, String> userSessions = this.getMap(key);
        if (userSessions != null) {
            JedisTemplate.PipelineActionNoResult action = new JedisTemplate.PipelineActionNoResult(){

                public void action(Pipeline pipeline) {
                    for (Map.Entry entry : userSessions.entrySet()) {
                        String t = (String)entry.getKey();
                        pipeline.del(t);
                    }
                    pipeline.del(key);
                }
            };
            this.execute(action);
        }
    }

    private void set(final String key, final String value) {
        this.execute(new JedisTemplate.JedisActionNoResult(){

            public void action(Jedis jedis) {
                jedis.set(key, value);
            }
        });
    }

    private String get(final String key) {
        return this.execute(new JedisTemplate.JedisAction<String>(){

            public String action(Jedis jedis) {
                return jedis.get(key);
            }
        });
    }

    private Boolean exists(final String key) {
        return this.execute(new JedisTemplate.JedisAction<Boolean>(){

            public Boolean action(Jedis jedis) {
                return jedis.exists(key);
            }
        });
    }

    private void execute(JedisTemplate.JedisActionNoResult jedisAction) throws JedisException {
        Jedis jedis = null;
        boolean broken = false;
        try {
            jedis = (Jedis)this.getSessionJedisPool().getResource();
            jedisAction.action(jedis);
        }
        catch (JedisException e) {
            broken = this.handleJedisException(e);
            throw e;
        }
        finally {
            this.closeResource(jedis, broken);
        }
    }

    private <T> T execute(JedisTemplate.JedisAction<T> jedisAction) throws JedisException {
        Jedis jedis = null;
        boolean broken = false;
        try {
            jedis = (Jedis)this.getSessionJedisPool().getResource();
            Object object = jedisAction.action(jedis);
            return (T)object;
        }
        catch (JedisException e) {
            broken = this.handleJedisException(e);
            throw e;
        }
        finally {
            this.closeResource(jedis, broken);
        }
    }

    private Boolean del(final String ... keys) {
        return this.execute(new JedisTemplate.JedisAction<Boolean>(){

            public Boolean action(Jedis jedis) {
                return jedis.del(keys) == (long)keys.length;
            }
        });
    }

    private <T extends Serializable> void hset(final String key, final String fieldName, final T value) {
        this.execute(new JedisTemplate.JedisActionNoResult(){

            public void action(Jedis jedis) {
                byte[] keyBytes = key.getBytes(Charset.forName(SessionManager.DEFAULT_CHARSET));
                byte[] fieldBytes = fieldName.getBytes(Charset.forName(SessionManager.DEFAULT_CHARSET));
                byte[] valueBytes = SerializUtil.objectToByte((Object)value);
                jedis.hset(keyBytes, fieldBytes, valueBytes);
            }
        });
    }

    private void sessionHset(final String key, final String fieldName, final String value) {
        this.execute(new JedisTemplate.JedisActionNoResult(){

            public void action(Jedis jedis) {
                jedis.hset(key, fieldName, value);
            }
        });
    }

    private String sessionHget(final String key, final String fieldName) {
        return this.execute(new JedisTemplate.JedisAction<String>(){

            public String action(Jedis jedis) {
                return jedis.hget(key, fieldName);
            }
        });
    }

    private <T extends Serializable> T hget(final String key, final String fieldName) {
        return (T)((Serializable)this.execute(new JedisTemplate.JedisAction<T>(){

            public T action(Jedis jedis) {
                byte[] fieldBytes;
                byte[] keyBytes = key.getBytes(Charset.forName(SessionManager.DEFAULT_CHARSET));
                byte[] attrBytes = jedis.hget(keyBytes, fieldBytes = fieldName.getBytes(Charset.forName(SessionManager.DEFAULT_CHARSET)));
                if (attrBytes == null) {
                    return null;
                }
                return (Serializable)SerializUtil.byteToObject((byte[])attrBytes);
            }
        }));
    }

    private Long hdel(final String key, final String ... fieldsNames) {
        return this.execute(new JedisTemplate.JedisAction<Long>(){

            public Long action(Jedis jedis) {
                return jedis.hdel(key, fieldsNames);
            }
        });
    }

    private Boolean hexists(final String key, final String field) {
        return this.execute(new JedisTemplate.JedisAction<Boolean>(){

            public Boolean action(Jedis jedis) {
                return jedis.hexists(key, field);
            }
        });
    }

    private Map<byte[], byte[]> hgetAll(final String key) {
        return this.execute(new JedisTemplate.JedisAction<Map<byte[], byte[]>>(){

            public Map<byte[], byte[]> action(Jedis jedis) {
                return jedis.hgetAll(key.getBytes(Charset.forName(SessionManager.DEFAULT_CHARSET)));
            }
        });
    }

    private Map<String, String> getMap(final String key) {
        return this.execute(new JedisTemplate.JedisAction<Map<String, String>>(){

            public Map<String, String> action(Jedis jedis) {
                return jedis.hgetAll(key);
            }
        });
    }

    private void expire(final String key, final int timeout) {
        this.execute(new JedisTemplate.JedisActionNoResult(){

            public void action(Jedis jedis) {
                jedis.expire(key, timeout);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleJedisException(JedisException jedisException) {
        if (jedisException instanceof JedisConnectionException) {
            this.logger.error("Redis connection " + this.getSessionJedisPool().getAddress() + " lost.", (Throwable)jedisException);
            return true;
        } else if (jedisException instanceof JedisDataException) {
            if (jedisException.getMessage() == null || jedisException.getMessage().indexOf("READONLY") == -1) return false;
            this.logger.error("Redis connection " + this.getSessionJedisPool().getAddress() + " are read-only slave.", (Throwable)jedisException);
            return true;
        } else {
            this.logger.error("Jedis exception happen.", (Throwable)jedisException);
        }
        return true;
    }

    private void closeResource(Jedis jedis, boolean conectionBroken) {
        try {
            if (conectionBroken) {
                this.getSessionJedisPool().returnBrokenResource(jedis);
            } else {
                this.getSessionJedisPool().returnResource(jedis);
            }
        }
        catch (Exception e) {
            this.logger.error("return back jedis failed, will fore close the jedis.", (Throwable)e);
            JedisUtils.destroyJedis((Jedis)jedis);
        }
    }

    private void execute(JedisTemplate.PipelineActionNoResult pipelineAction) throws JedisException {
        Jedis jedis = null;
        boolean broken = false;
        try {
            jedis = (Jedis)this.getSessionJedisPool().getResource();
            Pipeline pipeline = jedis.pipelined();
            pipelineAction.action(pipeline);
            pipeline.sync();
        }
        catch (JedisException e) {
            broken = this.handleJedisException(e);
            throw e;
        }
        finally {
            this.closeResource(jedis, broken);
        }
    }

    private List<Object> execute(JedisTemplate.PipelineAction pipelineAction) throws JedisException {
        Jedis jedis = null;
        boolean broken = false;
        try {
            jedis = (Jedis)this.getSessionJedisPool().getResource();
            Pipeline pipeline = jedis.pipelined();
            pipelineAction.action(pipeline);
            List list = pipeline.syncAndReturnAll();
            return list;
        }
        catch (JedisException e) {
            broken = this.handleJedisException(e);
            throw e;
        }
        finally {
            this.closeResource(jedis, broken);
        }
    }
}

