/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.auth.shiro;

import com.yonyou.iuap.auth.session.SessionManager;
import com.yonyou.iuap.auth.shiro.StatelessLogoutFilter;
import com.yonyou.iuap.auth.token.ITokenProcessor;
import com.yonyou.iuap.auth.token.TokenFactory;
import com.yonyou.iuap.utils.CookieUtil;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class LogoutFilter
extends StatelessLogoutFilter {
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private TokenFactory tokenFactory;

    @Override
    protected void doLogout(HttpServletRequest request, HttpServletResponse response) {
        String token = CookieUtil.findCookieValue((Cookie[])request.getCookies(), (String)"token");
        String userId = CookieUtil.findCookieValue((Cookie[])request.getCookies(), (String)"u_usercode");
        if (StringUtils.isNotBlank((String)token)) {
            ITokenProcessor tokenProcessor = this.tokenFactory.getTokenProcessor(token);
            Cookie[] cookies = tokenProcessor.getLogoutCookie(token, userId);
            for (int i = 0; i < cookies.length; ++i) {
                response.addCookie(cookies[i]);
            }
        }
    }
}

