/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.auth.shiro;

import com.yonyou.iuap.auth.shiro.StatelessToken;
import com.yonyou.iuap.auth.token.ITokenProcessor;
import com.yonyou.iuap.auth.token.TokenFactory;
import com.yonyou.iuap.auth.token.TokenParameter;
import com.yonyou.iuap.context.InvocationInfoProxy;
import com.yonyou.iuap.log.utils.ThreadCallerIdGenerator;
import com.yonyou.iuap.utils.CookieUtil;
import com.yonyou.iuap.utils.PropertyUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;

public class StatelessAuthcFilter
extends AccessControlFilter {
    private static final Logger log = LoggerFactory.getLogger(StatelessAuthcFilter.class);
    public static final int HTTP_STATUS_AUTH = 306;
    private String sysid;
    @Autowired
    private TokenFactory tokenFactory;
    private String[] esc = new String[]{"/logout", "/login", "/formLogin", ".jpg", ".png", ".gif", ".css", ".js", ".jpeg", "/oauth_login", "/oauth_approval"};
    private List<String> excludCongtextKeys = Arrays.asList("u_sysid", "tenantid", "u_callid", "u_usercode", "token", "u_logints", "u_locale", "u_theme", "u_timezone", "current_user_name", "call_thread_id", "current_tenant_id");

    public void setSysid(String sysid) {
        this.sysid = sysid;
    }

    public void setTokenFactory(TokenFactory tokenFactory) {
        this.tokenFactory = tokenFactory;
    }

    public void setEsc(String[] esc) {
        this.esc = esc;
    }

    public void setExcludCongtextKeys(List<String> excludCongtextKeys) {
        this.excludCongtextKeys = excludCongtextKeys;
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        return false;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        boolean needCheck;
        HttpServletRequest hReq;
        boolean isAjax = this.isAjax(request);
        HttpServletRequest httpRequest = hReq = (HttpServletRequest)request;
        Cookie[] cookies = httpRequest.getCookies();
        String authority = httpRequest.getHeader("Authority");
        if (StringUtils.isNotBlank((CharSequence)authority)) {
            String[] ac;
            HashSet<Cookie> cookieSet = new HashSet<Cookie>();
            for (String s : ac = authority.split(";")) {
                String[] cookieArr = s.split("=");
                String key = StringUtils.trim((String)cookieArr[0]);
                String value = StringUtils.trim((String)cookieArr[1]);
                Cookie cookie = new Cookie(key, value);
                cookieSet.add(cookie);
            }
            cookies = cookieSet.toArray(new Cookie[0]);
        }
        String tokenStr = CookieUtil.findCookieValue((Cookie[])cookies, (String)"token");
        String cookieUserName = CookieUtil.findCookieValue((Cookie[])cookies, (String)"u_usercode");
        String theme = CookieUtil.findCookieValue((Cookie[])cookies, (String)"u_theme");
        String locale = CookieUtil.findCookieValue((Cookie[])cookies, (String)"u_locale");
        String timeZone = CookieUtil.findCookieValue((Cookie[])cookies, (String)"u_timezone");
        String logints = CookieUtil.findCookieValue((Cookie[])cookies, (String)"u_logints");
        String callerThreadId = CookieUtil.findCookieValue((Cookie[])cookies, (String)"u_callid");
        if (StringUtils.isEmpty((CharSequence)this.sysid)) {
            throw new Exception("sysid is empty! add  sysid  parameter to 'StatelessAuthcFilter' bean in application-shiro.xml");
        }
        String username = request.getParameter("u_usercode");
        if (username == null && StringUtils.isNotBlank((CharSequence)cookieUserName)) {
            username = cookieUserName;
        }
        boolean bl = needCheck = !this.include(hReq);
        if (needCheck) {
            if (tokenStr == null || username == null) {
                if (isAjax) {
                    this.onAjaxAuthFail(request, response);
                } else {
                    this.onLoginFail(request, response);
                }
                return false;
            }
            HashMap params = new HashMap(request.getParameterMap());
            ITokenProcessor tokenProcessor = this.tokenFactory.getTokenProcessor(tokenStr);
            TokenParameter tp = tokenProcessor.getTokenParameterFromCookie(cookies);
            StatelessToken token = new StatelessToken(username, tokenProcessor, tp, params, new String(tokenStr));
            try {
                InvocationInfoProxy.setSysid((String)this.sysid);
                InvocationInfoProxy.setTheme((String)theme);
                InvocationInfoProxy.setLocale((String)locale);
                if (!StringUtils.isEmpty((CharSequence)timeZone)) {
                    InvocationInfoProxy.setTimeZone((String)timeZone);
                }
                this.getSubject(request, response).login((AuthenticationToken)token);
                InvocationInfoProxy.setUserid((String)username);
                InvocationInfoProxy.setLogints((String)logints);
                InvocationInfoProxy.setTenantid((String)tp.getExt().get("tenantid"));
                InvocationInfoProxy.setToken((String)tokenStr);
                InvocationInfoProxy.setCallid((String)callerThreadId);
                this.initExtendParams(cookies);
                this.initMDC();
                this.afterValidate(hReq);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                if (isAjax && e instanceof AuthenticationException) {
                    this.onAjaxAuthFail(request, response);
                    return false;
                }
                this.onLoginFail(request, response);
                return false;
            }
            return true;
        }
        return true;
    }

    private boolean isAjax(ServletRequest request) {
        HttpServletRequest rq;
        String requestType;
        boolean isAjax = false;
        if (request instanceof HttpServletRequest && (requestType = (rq = (HttpServletRequest)request).getHeader("X-Requested-With")) != null && "XMLHttpRequest".equals(requestType)) {
            isAjax = true;
        }
        return isAjax;
    }

    protected void onAjaxAuthFail(ServletRequest request, ServletResponse resp) throws IOException {
        HttpServletResponse response = (HttpServletResponse)resp;
        JSONObject json = new JSONObject();
        json.put((Object)"msg", (Object)"auth check error!");
        response.setStatus(306);
        response.getWriter().write(json.toString());
    }

    protected void onLoginFail(ServletRequest request, ServletResponse response) throws IOException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.setStatus(306);
        this.redirectToLogin(request, (ServletResponse)httpResponse);
    }

    protected void redirectToLogin(ServletRequest request, ServletResponse response) throws IOException {
        HttpServletRequest hReq = (HttpServletRequest)request;
        String rURL = hReq.getRequestURI();
        String qryString = hReq.getQueryString();
        if (qryString != null && !qryString.isEmpty()) {
            qryString = qryString + "?" + hReq.getQueryString();
        }
        rURL = Base64.encodeBase64URLSafeString((byte[])rURL.getBytes());
        String loginUrl = this.getLoginUrl() + "?r=" + rURL;
        WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)loginUrl);
    }

    public boolean include(HttpServletRequest request) {
        String u = request.getRequestURI();
        for (String e : this.esc) {
            if (!u.endsWith(e)) continue;
            return true;
        }
        String exeludeStr = PropertyUtil.getPropertyByKey((String)"filter_excludes");
        if (StringUtils.isNotBlank((CharSequence)exeludeStr)) {
            String[] customExcludes;
            for (String e : customExcludes = exeludeStr.split(",")) {
                if (!u.endsWith(e)) continue;
                return true;
            }
        }
        return false;
    }

    public void afterCompletion(ServletRequest request, ServletResponse response, Exception exception) throws Exception {
        super.afterCompletion(request, response, exception);
        InvocationInfoProxy.reset();
        this.clearMDC();
    }

    private void initExtendParams(Cookie[] cookies) {
        for (Cookie cookie : cookies) {
            String cname = cookie.getName();
            String cvalue = cookie.getValue();
            if (this.excludCongtextKeys.contains(cname)) continue;
            InvocationInfoProxy.setParameter((String)cname, (String)cvalue);
        }
    }

    private void initMDC() {
        String username = "";
        Subject subject = SecurityUtils.getSubject();
        if (subject != null && subject.getPrincipal() != null) {
            username = (String)SecurityUtils.getSubject().getPrincipal();
        }
        MDC.put((String)"current_user_name", (String)username);
        String call_thread_id = InvocationInfoProxy.getCallid();
        if (StringUtils.isBlank((CharSequence)call_thread_id)) {
            call_thread_id = ThreadCallerIdGenerator.genCallerThreadId();
            InvocationInfoProxy.setCallid((String)call_thread_id);
        } else {
            MDC.put((String)"call_thread_id", (String)call_thread_id);
        }
        MDC.put((String)"current_tenant_id", (String)InvocationInfoProxy.getTenantid());
        this.initCustomMDC();
    }

    protected void initCustomMDC() {
    }

    protected void afterValidate(HttpServletRequest hReq) {
    }

    protected void clearMDC() {
        MDC.remove((String)"current_user_name");
        MDC.remove((String)"call_thread_id");
        MDC.remove((String)"current_tenant_id");
        this.clearCustomMDC();
    }

    protected void clearCustomMDC() {
    }
}

