/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.auth.token;

import com.yonyou.iuap.auth.token.ITokenProcessor;
import com.yonyou.iuap.auth.token.TokenInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;

public class TokenFactory {
    private Map<String, ITokenProcessor> processors = new HashMap<String, ITokenProcessor>();

    public void setProcessors(List<ITokenProcessor> processors) {
        for (ITokenProcessor processor : processors) {
            this.processors.put(processor.getId(), processor);
        }
    }

    public ITokenProcessor getTokenProcessor(String token) {
        TokenInfo ti = TokenFactory.getTokenInfo(token);
        return this.getTokenProcessorById(ti.getProcessor());
    }

    public ITokenProcessor getTokenProcessorById(String id) {
        return this.processors.get(id);
    }

    public static TokenInfo getTokenInfo(String token) {
        String ntoken = StringUtils.newStringUtf8((byte[])Base64.decodeBase64((byte[])StringUtils.getBytesUtf8((String)token)));
        String[] tokenInfo = ntoken.split(",");
        TokenInfo ti = new TokenInfo();
        ti.setProcessor(tokenInfo[0]);
        ti.setExpr(tokenInfo[1]);
        ti.setToken(tokenInfo[2]);
        return ti;
    }
}

